/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.gen;

import com.google.common.base.Preconditions;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.bytecode.instruction.Constant;
import io.prestosql.sql.gen.BytecodeGenerator;
import io.prestosql.sql.gen.BytecodeGeneratorContext;
import io.prestosql.sql.relational.RowExpression;
import io.prestosql.sql.relational.SpecialForm;
import io.prestosql.type.UnknownType;
import java.util.Objects;

public class IsNullCodeGenerator
implements BytecodeGenerator {
    private final RowExpression argument;

    public IsNullCodeGenerator(SpecialForm specialForm) {
        Objects.requireNonNull(specialForm, "specialForm is null");
        Preconditions.checkArgument((specialForm.getArguments().size() == 1 ? 1 : 0) != 0);
        this.argument = specialForm.getArguments().get(0);
    }

    @Override
    public BytecodeNode generateExpression(BytecodeGeneratorContext generatorContext) {
        if (this.argument.getType().equals((Object)UnknownType.UNKNOWN)) {
            return Constant.loadBoolean((boolean)true);
        }
        BytecodeNode value = generatorContext.generate(this.argument);
        Variable wasNull = generatorContext.wasNull();
        BytecodeBlock block = new BytecodeBlock().comment("is null").append(value).pop(this.argument.getType().getJavaType()).append((BytecodeNode)wasNull);
        block.append((BytecodeNode)wasNull.set(BytecodeExpressions.constantFalse()));
        return block;
    }
}

