/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.prestosql.Session;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.OperatorNotFoundException;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.predicate.AllOrNoneValueSet;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.Marker;
import io.prestosql.spi.predicate.Range;
import io.prestosql.spi.predicate.Ranges;
import io.prestosql.spi.predicate.SortedRangeSet;
import io.prestosql.spi.predicate.ValueSet;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeOperators;
import io.prestosql.sql.InterpretedFunctionInvoker;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class DomainCoercer {
    private DomainCoercer() {
    }

    public static Domain applySaturatedCasts(Metadata metadata, TypeOperators typeOperators, Session session, Domain domain, Type coercedValueType) {
        return new ImplicitCoercer(metadata, typeOperators, session, domain, coercedValueType).applySaturatedCasts();
    }

    private static class ImplicitCoercer {
        private final ConnectorSession connectorSession;
        private final InterpretedFunctionInvoker functionInvoker;
        private final ResolvedFunction saturatedFloorCastOperator;
        private final ResolvedFunction castToOriginalTypeOperator;
        private final MethodHandle comparisonOperator;
        private final Domain domain;
        private final Type coercedValueType;

        private ImplicitCoercer(Metadata metadata, TypeOperators typeOperators, Session session, Domain domain, Type coercedValueType) {
            this.connectorSession = Objects.requireNonNull(session, "session is null").toConnectorSession();
            this.functionInvoker = new InterpretedFunctionInvoker(metadata);
            this.domain = Objects.requireNonNull(domain, "domain is null");
            this.coercedValueType = Objects.requireNonNull(coercedValueType, "coercedValueType is null");
            Type originalValueType = domain.getType();
            try {
                this.saturatedFloorCastOperator = metadata.getCoercion(OperatorType.SATURATED_FLOOR_CAST, originalValueType, coercedValueType);
            }
            catch (OperatorNotFoundException e) {
                throw new IllegalStateException(String.format("Saturated floor cast operator not found for coercion from %s to %s", originalValueType, coercedValueType));
            }
            this.castToOriginalTypeOperator = metadata.getCoercion(coercedValueType, originalValueType);
            this.comparisonOperator = typeOperators.getComparisonOperator(originalValueType, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}));
        }

        public Domain applySaturatedCasts() {
            if (this.domain.isNone()) {
                return Domain.none((Type)this.coercedValueType);
            }
            ValueSet saturatedValueSet = (ValueSet)this.domain.getValues().getValuesProcessor().transform(this::applySaturatedCasts, discreteValues -> ValueSet.all((Type)this.coercedValueType), allOrNone -> new AllOrNoneValueSet(this.coercedValueType, allOrNone.isAll()));
            return Domain.create((ValueSet)saturatedValueSet, (boolean)this.domain.isNullAllowed());
        }

        private ValueSet applySaturatedCasts(Ranges ranges) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Range range : ranges.getOrderedRanges()) {
                Optional<Range> coercedRange = this.applySaturatedCasts(range);
                if (coercedRange.isEmpty()) continue;
                if (coercedRange.get().isAll()) {
                    return ValueSet.all((Type)this.coercedValueType);
                }
                builder.add((Object)coercedRange.get());
            }
            return SortedRangeSet.copyOf((Type)this.coercedValueType, (List)builder.build());
        }

        private Optional<Range> applySaturatedCasts(Range range) {
            Marker coercedHigh;
            Marker coercedLow;
            if (range.isSingleValue()) {
                Optional<Object> coercedValue = this.applySaturatedCast(range.getSingleValue());
                return coercedValue.map(value -> Range.equal((Type)this.coercedValueType, (Object)value));
            }
            if (range.getLow().isLowerUnbounded()) {
                coercedLow = Marker.lowerUnbounded((Type)this.coercedValueType);
            } else {
                Object coercedLowValue;
                Object originalLowValue = range.getLow().getValue();
                int originalComparedToCoerced = this.compareOriginalValueToCoerced(this.castToOriginalTypeOperator, this.comparisonOperator, originalLowValue, coercedLowValue = this.floorValue(this.saturatedFloorCastOperator, originalLowValue));
                boolean coercedValueIsEqualToOriginal = originalComparedToCoerced == 0;
                boolean coercedValueIsLessThanOriginal = originalComparedToCoerced > 0;
                switch (range.getLow().getBound()) {
                    case ABOVE: {
                        if (coercedValueIsEqualToOriginal || coercedValueIsLessThanOriginal) {
                            coercedLow = Marker.above((Type)this.coercedValueType, (Object)coercedLowValue);
                            break;
                        }
                        coercedLow = Marker.lowerUnbounded((Type)this.coercedValueType);
                        break;
                    }
                    case EXACTLY: {
                        if (coercedValueIsEqualToOriginal) {
                            coercedLow = Marker.exactly((Type)this.coercedValueType, (Object)coercedLowValue);
                            break;
                        }
                        if (coercedValueIsLessThanOriginal) {
                            coercedLow = Marker.above((Type)this.coercedValueType, (Object)coercedLowValue);
                            break;
                        }
                        coercedLow = Marker.lowerUnbounded((Type)this.coercedValueType);
                        break;
                    }
                    case BELOW: {
                        throw new IllegalStateException("Low Marker should never use BELOW bound: " + range);
                    }
                    default: {
                        throw new IllegalStateException("Unhandled bound: " + range.getLow().getBound());
                    }
                }
            }
            if (range.getHigh().isUpperUnbounded()) {
                coercedHigh = Marker.upperUnbounded((Type)this.coercedValueType);
            } else {
                Object coercedHighValue;
                Object originalHighValue = range.getHigh().getValue();
                int originalComparedToCoerced = this.compareOriginalValueToCoerced(this.castToOriginalTypeOperator, this.comparisonOperator, originalHighValue, coercedHighValue = this.floorValue(this.saturatedFloorCastOperator, originalHighValue));
                boolean coercedValueIsEqualToOriginal = originalComparedToCoerced == 0;
                boolean coercedValueIsLessThanOriginal = originalComparedToCoerced > 0;
                switch (range.getHigh().getBound()) {
                    case ABOVE: {
                        throw new IllegalStateException("High Marker should never use ABOVE bound: " + range);
                    }
                    case EXACTLY: {
                        if (coercedValueIsEqualToOriginal || coercedValueIsLessThanOriginal) {
                            coercedHigh = Marker.exactly((Type)this.coercedValueType, (Object)coercedHighValue);
                            break;
                        }
                        return Optional.empty();
                    }
                    case BELOW: {
                        if (coercedValueIsEqualToOriginal) {
                            coercedHigh = Marker.below((Type)this.coercedValueType, (Object)coercedHighValue);
                            break;
                        }
                        if (coercedValueIsLessThanOriginal) {
                            coercedHigh = Marker.exactly((Type)this.coercedValueType, (Object)coercedHighValue);
                            break;
                        }
                        return Optional.empty();
                    }
                    default: {
                        throw new IllegalStateException("Unhandled bound: " + range.getHigh().getBound());
                    }
                }
            }
            if (coercedLow.compareTo(coercedHigh) > 0) {
                return Optional.empty();
            }
            return Optional.of(new Range(coercedLow, coercedHigh));
        }

        private Optional<Object> applySaturatedCast(Object originalValue) {
            Object coercedFloorValue = this.floorValue(this.saturatedFloorCastOperator, originalValue);
            int originalComparedToCoerced = this.compareOriginalValueToCoerced(this.castToOriginalTypeOperator, this.comparisonOperator, originalValue, coercedFloorValue);
            if (originalComparedToCoerced == 0) {
                return Optional.of(coercedFloorValue);
            }
            return Optional.empty();
        }

        private int compareOriginalValueToCoerced(ResolvedFunction castToOriginalTypeOperator, MethodHandle comparisonOperator, Object originalValue, Object coercedValue) {
            Object coercedValueInOriginalType = this.functionInvoker.invoke(castToOriginalTypeOperator, this.connectorSession, coercedValue);
            try {
                return (int)comparisonOperator.invoke(originalValue, coercedValueInOriginalType);
            }
            catch (Throwable throwable) {
                Throwables.throwIfUnchecked((Throwable)throwable);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, throwable);
            }
        }

        private Object floorValue(ResolvedFunction saturatedFloorCastOperator, Object value) {
            return this.functionInvoker.invoke(saturatedFloorCastOperator, this.connectorSession, value);
        }
    }
}

