/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.prestosql.Session;
import io.prestosql.execution.Column;
import io.prestosql.execution.Input;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.TableHandle;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.sql.planner.SubPlan;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.plan.IndexSourceNode;
import io.prestosql.sql.planner.plan.PlanFragmentId;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.PlanVisitor;
import io.prestosql.sql.planner.plan.TableScanNode;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class InputExtractor {
    private final Metadata metadata;
    private final Session session;

    public InputExtractor(Metadata metadata, Session session) {
        this.metadata = metadata;
        this.session = session;
    }

    public List<Input> extractInputs(SubPlan root) {
        Visitor visitor = new Visitor();
        root.getAllFragments().forEach(fragment -> fragment.getRoot().accept(visitor, fragment.getId()));
        return ImmutableList.copyOf(visitor.getInputs());
    }

    private static Column createColumn(ColumnMetadata columnMetadata) {
        return new Column(columnMetadata.getName(), columnMetadata.getType().toString());
    }

    private Input createInput(Session session, TableHandle table, Set<Column> columns, PlanFragmentId fragmentId, PlanNodeId planNodeId) {
        SchemaTableName schemaTable = this.metadata.getTableMetadata(session, table).getTable();
        Optional<Object> inputMetadata = this.metadata.getInfo(session, table);
        return new Input(table.getCatalogName().getCatalogName(), schemaTable.getSchemaName(), schemaTable.getTableName(), inputMetadata, (List<Column>)ImmutableList.copyOf(columns), fragmentId, planNodeId);
    }

    private class Visitor
    extends PlanVisitor<Void, PlanFragmentId> {
        private final ImmutableSet.Builder<Input> inputs = ImmutableSet.builder();

        private Visitor() {
        }

        public Set<Input> getInputs() {
            return this.inputs.build();
        }

        @Override
        public Void visitTableScan(TableScanNode node, PlanFragmentId fragmentId) {
            this.processScan(fragmentId, node.getId(), node.getTable(), node.getAssignments());
            return null;
        }

        @Override
        public Void visitIndexSource(IndexSourceNode node, PlanFragmentId fragmentId) {
            this.processScan(fragmentId, node.getId(), node.getTableHandle(), node.getAssignments());
            return null;
        }

        private void processScan(PlanFragmentId fragmentId, PlanNodeId planNodeId, TableHandle tableHandle, Map<Symbol, ColumnHandle> assignments) {
            HashSet<Column> columns = new HashSet<Column>();
            for (ColumnHandle columnHandle : assignments.values()) {
                columns.add(InputExtractor.createColumn(InputExtractor.this.metadata.getColumnMetadata(InputExtractor.this.session, tableHandle, columnHandle)));
            }
            this.inputs.add((Object)InputExtractor.this.createInput(InputExtractor.this.session, tableHandle, columns, fragmentId, planNodeId));
        }

        @Override
        protected Void visitPlan(PlanNode node, PlanFragmentId fragmentId) {
            for (PlanNode child : node.getSources()) {
                child.accept(this, fragmentId);
            }
            return null;
        }
    }
}

