/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.spi.expression.ConnectorExpression;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.ConnectorExpressionTranslator;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.LambdaExpression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class PartialTranslator {
    private PartialTranslator() {
    }

    public static Map<NodeRef<Expression>, ConnectorExpression> extractPartialTranslations(Expression inputExpression, Session session, TypeAnalyzer typeAnalyzer, TypeProvider typeProvider) {
        Objects.requireNonNull(inputExpression, "expressions is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        Objects.requireNonNull(typeProvider, "typeProvider is null");
        HashMap<NodeRef<Expression>, ConnectorExpression> partialTranslations = new HashMap<NodeRef<Expression>, ConnectorExpression>();
        new Visitor(typeAnalyzer.getTypes(session, typeProvider, inputExpression), partialTranslations).process((Node)inputExpression);
        return ImmutableMap.copyOf(partialTranslations);
    }

    private static class Visitor
    extends AstVisitor<Void, Void> {
        private final Map<NodeRef<Expression>, ConnectorExpression> translatedSubExpressions;
        private final ConnectorExpressionTranslator.SqlToConnectorExpressionTranslator translator;

        Visitor(Map<NodeRef<Expression>, Type> types, Map<NodeRef<Expression>, ConnectorExpression> translatedSubExpressions) {
            Objects.requireNonNull(types, "types is null");
            this.translatedSubExpressions = Objects.requireNonNull(translatedSubExpressions, "translatedSubExpressions is null");
            this.translator = new ConnectorExpressionTranslator.SqlToConnectorExpressionTranslator(types);
        }

        public Void visitExpression(Expression node, Void context) {
            Optional result = (Optional)this.translator.process((Node)node);
            if (result.isPresent()) {
                this.translatedSubExpressions.put((NodeRef<Expression>)NodeRef.of((Node)node), (ConnectorExpression)result.get());
            } else {
                node.getChildren().forEach(arg_0 -> ((Visitor)this).process(arg_0));
            }
            return null;
        }

        public Void visitLambdaExpression(LambdaExpression functionCall, Void context) {
            return null;
        }
    }
}

