/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import io.prestosql.Session;
import io.prestosql.SystemSessionProperties;
import io.prestosql.cost.StatsAndCosts;
import io.prestosql.execution.QueryManagerConfig;
import io.prestosql.execution.scheduler.BucketNodeMap;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.TableHandle;
import io.prestosql.metadata.TableProperties;
import io.prestosql.operator.StageExecutionDescriptor;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.PrestoWarning;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.WarningCodeSupplier;
import io.prestosql.spi.connector.ConnectorPartitionHandle;
import io.prestosql.spi.connector.ConnectorPartitioningHandle;
import io.prestosql.spi.connector.NotPartitionedPartitionHandle;
import io.prestosql.spi.connector.StandardWarningCode;
import io.prestosql.sql.planner.NodePartitioningManager;
import io.prestosql.sql.planner.Partitioning;
import io.prestosql.sql.planner.PartitioningHandle;
import io.prestosql.sql.planner.PartitioningScheme;
import io.prestosql.sql.planner.Plan;
import io.prestosql.sql.planner.PlanFragment;
import io.prestosql.sql.planner.SchedulingOrderVisitor;
import io.prestosql.sql.planner.SubPlan;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SymbolsExtractor;
import io.prestosql.sql.planner.SystemPartitioningHandle;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.ExchangeNode;
import io.prestosql.sql.planner.plan.ExplainAnalyzeNode;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.OutputNode;
import io.prestosql.sql.planner.plan.PlanFragmentId;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.PlanVisitor;
import io.prestosql.sql.planner.plan.RemoteSourceNode;
import io.prestosql.sql.planner.plan.RowNumberNode;
import io.prestosql.sql.planner.plan.SimplePlanRewriter;
import io.prestosql.sql.planner.plan.StatisticsWriterNode;
import io.prestosql.sql.planner.plan.TableDeleteNode;
import io.prestosql.sql.planner.plan.TableFinishNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import io.prestosql.sql.planner.plan.TableWriterNode;
import io.prestosql.sql.planner.plan.TopNRowNumberNode;
import io.prestosql.sql.planner.plan.ValuesNode;
import io.prestosql.sql.planner.plan.WindowNode;
import io.prestosql.sql.planner.planprinter.PlanPrinter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class PlanFragmenter {
    private static final String TOO_MANY_STAGES_MESSAGE = "If the query contains multiple aggregates with DISTINCT over different columns, please set the 'use_mark_distinct' session property to false. If the query contains WITH clauses that are referenced more than once, please create temporary table(s) for the queries in those clauses.";
    private final Metadata metadata;
    private final NodePartitioningManager nodePartitioningManager;
    private final QueryManagerConfig config;

    @Inject
    public PlanFragmenter(Metadata metadata, NodePartitioningManager nodePartitioningManager, QueryManagerConfig queryManagerConfig) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.nodePartitioningManager = Objects.requireNonNull(nodePartitioningManager, "nodePartitioningManager is null");
        this.config = Objects.requireNonNull(queryManagerConfig, "queryManagerConfig is null");
    }

    public SubPlan createSubPlans(Session session, Plan plan, boolean forceSingleNode, WarningCollector warningCollector) {
        Fragmenter fragmenter = new Fragmenter(session, this.metadata, plan.getTypes(), plan.getStatsAndCosts());
        FragmentProperties properties = new FragmentProperties(new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), plan.getRoot().getOutputSymbols()));
        if (forceSingleNode || SystemSessionProperties.isForceSingleNodeOutput(session)) {
            properties = properties.setSingleNodeDistribution();
        }
        PlanNode root = SimplePlanRewriter.rewriteWith(fragmenter, plan.getRoot(), properties);
        SubPlan subPlan = fragmenter.buildRootFragment(root, properties);
        subPlan = this.reassignPartitioningHandleIfNecessary(session, subPlan);
        subPlan = this.analyzeGroupedExecution(session, subPlan);
        Preconditions.checkState((!SystemSessionProperties.isForceSingleNodeOutput(session) || subPlan.getFragment().getPartitioning().isSingleNode() ? 1 : 0) != 0, (Object)"Root of PlanFragment is not single node");
        this.sanityCheckFragmentedPlan(subPlan, warningCollector, SystemSessionProperties.getQueryMaxStageCount(session), this.config.getStageCountWarningThreshold());
        return subPlan;
    }

    private void sanityCheckFragmentedPlan(SubPlan subPlan, WarningCollector warningCollector, int maxStageCount, int stageCountSoftLimit) {
        subPlan.sanityCheck();
        int fragmentCount = subPlan.getAllFragments().size();
        if (fragmentCount > maxStageCount) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.QUERY_HAS_TOO_MANY_STAGES, String.format("Number of stages in the query (%s) exceeds the allowed maximum (%s). %s", fragmentCount, maxStageCount, TOO_MANY_STAGES_MESSAGE));
        }
        if (fragmentCount > stageCountSoftLimit) {
            warningCollector.add(new PrestoWarning((WarningCodeSupplier)StandardWarningCode.TOO_MANY_STAGES, String.format("Number of stages in the query (%s) exceeds the soft limit (%s). %s", fragmentCount, stageCountSoftLimit, TOO_MANY_STAGES_MESSAGE)));
        }
    }

    private SubPlan analyzeGroupedExecution(Session session, SubPlan subPlan) {
        PlanFragment fragment = subPlan.getFragment();
        GroupedExecutionProperties properties = fragment.getRoot().accept(new GroupedExecutionTagger(session, this.metadata, this.nodePartitioningManager), null);
        if (properties.isSubTreeUseful()) {
            boolean preferDynamic = fragment.getRemoteSourceNodes().stream().allMatch(node -> node.getExchangeType() == ExchangeNode.Type.REPLICATE) && SystemSessionProperties.isDynamicScheduleForGroupedExecution(session);
            BucketNodeMap bucketNodeMap = this.nodePartitioningManager.getBucketNodeMap(session, fragment.getPartitioning(), preferDynamic);
            fragment = bucketNodeMap.isDynamic() ? fragment.withDynamicLifespanScheduleGroupedExecution(properties.getCapableTableScanNodes()) : fragment.withFixedLifespanScheduleGroupedExecution(properties.getCapableTableScanNodes());
        }
        ImmutableList.Builder result = ImmutableList.builder();
        for (SubPlan child : subPlan.getChildren()) {
            result.add((Object)this.analyzeGroupedExecution(session, child));
        }
        return new SubPlan(fragment, (List<SubPlan>)result.build());
    }

    private SubPlan reassignPartitioningHandleIfNecessary(Session session, SubPlan subPlan) {
        return this.reassignPartitioningHandleIfNecessaryHelper(session, subPlan, subPlan.getFragment().getPartitioning());
    }

    private SubPlan reassignPartitioningHandleIfNecessaryHelper(Session session, SubPlan subPlan, PartitioningHandle newOutputPartitioningHandle) {
        PlanFragment fragment = subPlan.getFragment();
        PlanNode newRoot = fragment.getRoot();
        if (!fragment.getPartitioning().isSingleNode()) {
            PartitioningHandleReassigner partitioningHandleReassigner = new PartitioningHandleReassigner(fragment.getPartitioning(), this.metadata, session);
            newRoot = SimplePlanRewriter.rewriteWith(partitioningHandleReassigner, newRoot);
        }
        PartitioningScheme outputPartitioningScheme = fragment.getPartitioningScheme();
        Partitioning newOutputPartitioning = outputPartitioningScheme.getPartitioning();
        if (outputPartitioningScheme.getPartitioning().getHandle().getConnectorId().isPresent()) {
            newOutputPartitioning = newOutputPartitioning.withAlternativePartitiongingHandle(newOutputPartitioningHandle);
        }
        PlanFragment newFragment = new PlanFragment(fragment.getId(), newRoot, fragment.getSymbols(), fragment.getPartitioning(), fragment.getPartitionedSources(), new PartitioningScheme(newOutputPartitioning, outputPartitioningScheme.getOutputLayout(), outputPartitioningScheme.getHashColumn(), outputPartitioningScheme.isReplicateNullsAndAny(), outputPartitioningScheme.getBucketToPartition()), fragment.getStageExecutionDescriptor(), fragment.getStatsAndCosts(), fragment.getJsonRepresentation());
        ImmutableList.Builder childrenBuilder = ImmutableList.builder();
        for (SubPlan child : subPlan.getChildren()) {
            childrenBuilder.add((Object)this.reassignPartitioningHandleIfNecessaryHelper(session, child, fragment.getPartitioning()));
        }
        return new SubPlan(newFragment, (List<SubPlan>)childrenBuilder.build());
    }

    private static final class PartitioningHandleReassigner
    extends SimplePlanRewriter<Void> {
        private final PartitioningHandle fragmentPartitioningHandle;
        private final Metadata metadata;
        private final Session session;

        public PartitioningHandleReassigner(PartitioningHandle fragmentPartitioningHandle, Metadata metadata, Session session) {
            this.fragmentPartitioningHandle = fragmentPartitioningHandle;
            this.metadata = metadata;
            this.session = session;
        }

        @Override
        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PartitioningHandle partitioning = this.metadata.getTableProperties(this.session, node.getTable()).getTablePartitioning().map(TableProperties.TablePartitioning::getPartitioningHandle).orElse(SystemPartitioningHandle.SOURCE_DISTRIBUTION);
            if (partitioning.equals(this.fragmentPartitioningHandle)) {
                return node;
            }
            TableHandle newTable = this.metadata.makeCompatiblePartitioning(this.session, node.getTable(), this.fragmentPartitioningHandle);
            return new TableScanNode(node.getId(), newTable, node.getOutputSymbols(), node.getAssignments(), node.getEnforcedConstraint(), node.isForDelete());
        }
    }

    private static class GroupedExecutionProperties {
        private final boolean currentNodeCapable;
        private final boolean subTreeUseful;
        private final List<PlanNodeId> capableTableScanNodes;

        public GroupedExecutionProperties(boolean currentNodeCapable, boolean subTreeUseful, List<PlanNodeId> capableTableScanNodes) {
            this.currentNodeCapable = currentNodeCapable;
            this.subTreeUseful = subTreeUseful;
            this.capableTableScanNodes = ImmutableList.copyOf((Collection)Objects.requireNonNull(capableTableScanNodes, "capableTableScanNodes is null"));
            Preconditions.checkArgument((!subTreeUseful || currentNodeCapable ? 1 : 0) != 0);
            Preconditions.checkArgument((currentNodeCapable == !capableTableScanNodes.isEmpty() ? 1 : 0) != 0);
        }

        public static GroupedExecutionProperties notCapable() {
            return new GroupedExecutionProperties(false, false, (List<PlanNodeId>)ImmutableList.of());
        }

        public boolean isCurrentNodeCapable() {
            return this.currentNodeCapable;
        }

        public boolean isSubTreeUseful() {
            return this.subTreeUseful;
        }

        public List<PlanNodeId> getCapableTableScanNodes() {
            return this.capableTableScanNodes;
        }
    }

    private static class GroupedExecutionTagger
    extends PlanVisitor<GroupedExecutionProperties, Void> {
        private final Session session;
        private final Metadata metadata;
        private final NodePartitioningManager nodePartitioningManager;
        private final boolean groupedExecutionEnabled;

        public GroupedExecutionTagger(Session session, Metadata metadata, NodePartitioningManager nodePartitioningManager) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.nodePartitioningManager = Objects.requireNonNull(nodePartitioningManager, "nodePartitioningManager is null");
            this.groupedExecutionEnabled = SystemSessionProperties.isGroupedExecutionEnabled(session);
        }

        @Override
        protected GroupedExecutionProperties visitPlan(PlanNode node, Void context) {
            if (node.getSources().isEmpty()) {
                return GroupedExecutionProperties.notCapable();
            }
            return this.processChildren(node);
        }

        @Override
        public GroupedExecutionProperties visitJoin(JoinNode node, Void context) {
            GroupedExecutionProperties left = node.getLeft().accept(this, null);
            GroupedExecutionProperties right = node.getRight().accept(this, null);
            if (node.getDistributionType().isEmpty()) {
                return GroupedExecutionProperties.notCapable();
            }
            if (!(node.getType() != JoinNode.Type.RIGHT && node.getType() != JoinNode.Type.FULL || right.currentNodeCapable)) {
                return GroupedExecutionProperties.notCapable();
            }
            switch (node.getDistributionType().get()) {
                case REPLICATED: {
                    Preconditions.checkState((!right.currentNodeCapable ? 1 : 0) != 0);
                    return left;
                }
                case PARTITIONED: {
                    if (left.currentNodeCapable && right.currentNodeCapable) {
                        return new GroupedExecutionProperties(true, true, (List<PlanNodeId>)ImmutableList.builder().addAll(left.capableTableScanNodes).addAll(right.capableTableScanNodes).build());
                    }
                    return left;
                }
            }
            throw new UnsupportedOperationException("Unknown distribution type: " + node.getDistributionType());
        }

        @Override
        public GroupedExecutionProperties visitAggregation(AggregationNode node, Void context) {
            GroupedExecutionProperties properties = node.getSource().accept(this, null);
            if (this.groupedExecutionEnabled && properties.isCurrentNodeCapable()) {
                switch (node.getStep()) {
                    case SINGLE: 
                    case FINAL: {
                        return new GroupedExecutionProperties(true, true, properties.capableTableScanNodes);
                    }
                    case PARTIAL: 
                    case INTERMEDIATE: {
                        return properties;
                    }
                }
            }
            return GroupedExecutionProperties.notCapable();
        }

        @Override
        public GroupedExecutionProperties visitWindow(WindowNode node, Void context) {
            return this.processWindowFunction(node);
        }

        @Override
        public GroupedExecutionProperties visitRowNumber(RowNumberNode node, Void context) {
            return this.processWindowFunction(node);
        }

        @Override
        public GroupedExecutionProperties visitTopNRowNumber(TopNRowNumberNode node, Void context) {
            return this.processWindowFunction(node);
        }

        private GroupedExecutionProperties processWindowFunction(PlanNode node) {
            GroupedExecutionProperties properties = ((PlanNode)Iterables.getOnlyElement(node.getSources())).accept(this, null);
            if (this.groupedExecutionEnabled && properties.isCurrentNodeCapable()) {
                return new GroupedExecutionProperties(true, true, properties.capableTableScanNodes);
            }
            return GroupedExecutionProperties.notCapable();
        }

        @Override
        public GroupedExecutionProperties visitTableScan(TableScanNode node, Void context) {
            Optional<TableProperties.TablePartitioning> tablePartitioning = this.metadata.getTableProperties(this.session, node.getTable()).getTablePartitioning();
            if (tablePartitioning.isEmpty()) {
                return GroupedExecutionProperties.notCapable();
            }
            List<ConnectorPartitionHandle> partitionHandles = this.nodePartitioningManager.listPartitionHandles(this.session, tablePartitioning.get().getPartitioningHandle());
            if (ImmutableList.of((Object)NotPartitionedPartitionHandle.NOT_PARTITIONED).equals(partitionHandles)) {
                return new GroupedExecutionProperties(false, false, (List<PlanNodeId>)ImmutableList.of());
            }
            return new GroupedExecutionProperties(true, false, (List<PlanNodeId>)ImmutableList.of((Object)node.getId()));
        }

        private GroupedExecutionProperties processChildren(PlanNode node) {
            boolean anyUseful = false;
            ImmutableList.Builder capableTableScanNodes = ImmutableList.builder();
            for (PlanNode source : node.getSources()) {
                GroupedExecutionProperties properties = source.accept(this, null);
                if (!properties.isCurrentNodeCapable()) {
                    return GroupedExecutionProperties.notCapable();
                }
                anyUseful |= properties.isSubTreeUseful();
                capableTableScanNodes.addAll(properties.capableTableScanNodes);
            }
            return new GroupedExecutionProperties(true, anyUseful, (List<PlanNodeId>)capableTableScanNodes.build());
        }
    }

    private static class FragmentProperties {
        private final List<SubPlan> children = new ArrayList<SubPlan>();
        private final PartitioningScheme partitioningScheme;
        private Optional<PartitioningHandle> partitioningHandle = Optional.empty();
        private final Set<PlanNodeId> partitionedSources = new HashSet<PlanNodeId>();

        public FragmentProperties(PartitioningScheme partitioningScheme) {
            this.partitioningScheme = partitioningScheme;
        }

        public List<SubPlan> getChildren() {
            return this.children;
        }

        public FragmentProperties setSingleNodeDistribution() {
            if (this.partitioningHandle.isPresent() && this.partitioningHandle.get().isSingleNode()) {
                return this;
            }
            Preconditions.checkState((boolean)this.partitioningHandle.isEmpty(), (String)"Cannot overwrite partitioning with %s (currently set to %s)", (Object)SystemPartitioningHandle.SINGLE_DISTRIBUTION, this.partitioningHandle);
            this.partitioningHandle = Optional.of(SystemPartitioningHandle.SINGLE_DISTRIBUTION);
            return this;
        }

        public FragmentProperties setDistribution(PartitioningHandle distribution, Metadata metadata, Session session) {
            if (this.partitioningHandle.isEmpty()) {
                this.partitioningHandle = Optional.of(distribution);
                return this;
            }
            PartitioningHandle currentPartitioning = this.partitioningHandle.get();
            if (this.isCompatibleSystemPartitioning(distribution)) {
                return this;
            }
            if (currentPartitioning.equals(SystemPartitioningHandle.SOURCE_DISTRIBUTION)) {
                this.partitioningHandle = Optional.of(distribution);
                return this;
            }
            if (currentPartitioning.isSingleNode()) {
                return this;
            }
            if (currentPartitioning.equals(distribution)) {
                return this;
            }
            Optional<PartitioningHandle> commonPartitioning = metadata.getCommonPartitioning(session, currentPartitioning, distribution);
            if (commonPartitioning.isPresent()) {
                this.partitioningHandle = commonPartitioning;
                return this;
            }
            throw new IllegalStateException(String.format("Cannot set distribution to %s. Already set to %s", distribution, this.partitioningHandle));
        }

        private boolean isCompatibleSystemPartitioning(PartitioningHandle distribution) {
            ConnectorPartitioningHandle currentHandle = this.partitioningHandle.get().getConnectorHandle();
            ConnectorPartitioningHandle distributionHandle = distribution.getConnectorHandle();
            if (currentHandle instanceof SystemPartitioningHandle && distributionHandle instanceof SystemPartitioningHandle) {
                return ((SystemPartitioningHandle)currentHandle).getPartitioning() == ((SystemPartitioningHandle)distributionHandle).getPartitioning();
            }
            return false;
        }

        public FragmentProperties setCoordinatorOnlyDistribution() {
            if (this.partitioningHandle.isPresent() && this.partitioningHandle.get().isCoordinatorOnly()) {
                return this;
            }
            Preconditions.checkState((this.partitioningHandle.isEmpty() || this.partitioningHandle.get().equals(SystemPartitioningHandle.SINGLE_DISTRIBUTION) ? 1 : 0) != 0, (String)"Cannot overwrite partitioning with %s (currently set to %s)", (Object)SystemPartitioningHandle.COORDINATOR_DISTRIBUTION, this.partitioningHandle);
            this.partitioningHandle = Optional.of(SystemPartitioningHandle.COORDINATOR_DISTRIBUTION);
            return this;
        }

        public FragmentProperties addSourceDistribution(PlanNodeId source, PartitioningHandle distribution, Metadata metadata, Session session) {
            Objects.requireNonNull(source, "source is null");
            Objects.requireNonNull(distribution, "distribution is null");
            this.partitionedSources.add(source);
            if (this.partitioningHandle.isEmpty()) {
                this.partitioningHandle = Optional.of(distribution);
                return this;
            }
            PartitioningHandle currentPartitioning = this.partitioningHandle.get();
            if (currentPartitioning.equals(SystemPartitioningHandle.SINGLE_DISTRIBUTION) || currentPartitioning.equals(SystemPartitioningHandle.COORDINATOR_DISTRIBUTION)) {
                return this;
            }
            if (currentPartitioning.equals(distribution)) {
                return this;
            }
            Optional<PartitioningHandle> commonPartitioning = metadata.getCommonPartitioning(session, currentPartitioning, distribution);
            if (commonPartitioning.isPresent()) {
                this.partitioningHandle = commonPartitioning;
                return this;
            }
            throw new IllegalStateException(String.format("Cannot overwrite distribution with %s (currently set to %s)", distribution, currentPartitioning));
        }

        public FragmentProperties addChildren(List<SubPlan> children) {
            this.children.addAll(children);
            return this;
        }

        public PartitioningScheme getPartitioningScheme() {
            return this.partitioningScheme;
        }

        public PartitioningHandle getPartitioningHandle() {
            return this.partitioningHandle.get();
        }

        public Set<PlanNodeId> getPartitionedSources() {
            return this.partitionedSources;
        }
    }

    private static class Fragmenter
    extends SimplePlanRewriter<FragmentProperties> {
        private static final int ROOT_FRAGMENT_ID = 0;
        private final Session session;
        private final Metadata metadata;
        private final TypeProvider types;
        private final StatsAndCosts statsAndCosts;
        private int nextFragmentId = 1;

        public Fragmenter(Session session, Metadata metadata, TypeProvider types, StatsAndCosts statsAndCosts) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.types = Objects.requireNonNull(types, "types is null");
            this.statsAndCosts = Objects.requireNonNull(statsAndCosts, "statsAndCosts is null");
        }

        public SubPlan buildRootFragment(PlanNode root, FragmentProperties properties) {
            return this.buildFragment(root, properties, new PlanFragmentId(String.valueOf(0)));
        }

        private PlanFragmentId nextFragmentId() {
            return new PlanFragmentId(String.valueOf(this.nextFragmentId++));
        }

        private SubPlan buildFragment(PlanNode root, FragmentProperties properties, PlanFragmentId fragmentId) {
            Set<Symbol> dependencies = SymbolsExtractor.extractOutputSymbols(root);
            List<PlanNodeId> schedulingOrder = SchedulingOrderVisitor.scheduleOrder(root);
            boolean equals = properties.getPartitionedSources().equals(ImmutableSet.copyOf(schedulingOrder));
            Preconditions.checkArgument((boolean)equals, (String)"Expected scheduling order (%s) to contain an entry for all partitioned sources (%s)", schedulingOrder, properties.getPartitionedSources());
            Map symbols = Maps.filterKeys(this.types.allTypes(), (Predicate)Predicates.in(dependencies));
            PlanFragment fragment = new PlanFragment(fragmentId, root, symbols, properties.getPartitioningHandle(), schedulingOrder, properties.getPartitioningScheme(), StageExecutionDescriptor.ungroupedExecution(), this.statsAndCosts.getForSubplan(root), Optional.of(PlanPrinter.jsonFragmentPlan(root, symbols, this.metadata, this.session)));
            return new SubPlan(fragment, properties.getChildren());
        }

        @Override
        public PlanNode visitOutput(OutputNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            if (SystemSessionProperties.isForceSingleNodeOutput(this.session)) {
                context.get().setSingleNodeDistribution();
            }
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitExplainAnalyze(ExplainAnalyzeNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setCoordinatorOnlyDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitStatisticsWriterNode(StatisticsWriterNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setCoordinatorOnlyDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitTableFinish(TableFinishNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setCoordinatorOnlyDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitTableDelete(TableDeleteNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setCoordinatorOnlyDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            PartitioningHandle partitioning = this.metadata.getTableProperties(this.session, node.getTable()).getTablePartitioning().map(TableProperties.TablePartitioning::getPartitioningHandle).orElse(SystemPartitioningHandle.SOURCE_DISTRIBUTION);
            context.get().addSourceDistribution(node.getId(), partitioning, this.metadata, this.session);
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitTableWriter(TableWriterNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            if (node.getPartitioningScheme().isPresent()) {
                context.get().setDistribution(node.getPartitioningScheme().get().getPartitioning().getHandle(), this.metadata, this.session);
            }
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitValues(ValuesNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setSingleNodeDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitExchange(ExchangeNode exchange, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            if (exchange.getScope() != ExchangeNode.Scope.REMOTE) {
                return context.defaultRewrite(exchange, context.get());
            }
            PartitioningScheme partitioningScheme = exchange.getPartitioningScheme();
            if (exchange.getType() == ExchangeNode.Type.GATHER) {
                context.get().setSingleNodeDistribution();
            } else if (exchange.getType() == ExchangeNode.Type.REPARTITION) {
                context.get().setDistribution(partitioningScheme.getPartitioning().getHandle(), this.metadata, this.session);
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int sourceIndex = 0; sourceIndex < exchange.getSources().size(); ++sourceIndex) {
                FragmentProperties childProperties = new FragmentProperties(partitioningScheme.translateOutputLayout(exchange.getInputs().get(sourceIndex)));
                builder.add((Object)this.buildSubPlan(exchange.getSources().get(sourceIndex), childProperties, context));
            }
            ImmutableList children = builder.build();
            context.get().addChildren((List<SubPlan>)children);
            List childrenIds = (List)children.stream().map(SubPlan::getFragment).map(PlanFragment::getId).collect(ImmutableList.toImmutableList());
            return new RemoteSourceNode(exchange.getId(), childrenIds, exchange.getOutputSymbols(), exchange.getOrderingScheme(), exchange.getType());
        }

        private SubPlan buildSubPlan(PlanNode node, FragmentProperties properties, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            PlanFragmentId planFragmentId = this.nextFragmentId();
            PlanNode child = context.rewrite(node, properties);
            return this.buildFragment(child, properties, planFragmentId);
        }
    }
}

