/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.OffsetNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.planner.plan.RowNumberNode;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.GenericLiteral;
import java.util.List;
import java.util.Optional;

public class ImplementOffset
implements Rule<OffsetNode> {
    private static final Pattern<OffsetNode> PATTERN = Patterns.offset();

    @Override
    public Pattern<OffsetNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(OffsetNode parent, Captures captures, Rule.Context context) {
        Symbol rowNumberSymbol = context.getSymbolAllocator().newSymbol("row_number", (Type)BigintType.BIGINT);
        RowNumberNode rowNumberNode = new RowNumberNode(context.getIdAllocator().getNextId(), parent.getSource(), (List<Symbol>)ImmutableList.of(), true, rowNumberSymbol, Optional.empty(), Optional.empty());
        FilterNode filterNode = new FilterNode(context.getIdAllocator().getNextId(), rowNumberNode, (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)rowNumberSymbol.toSymbolReference(), (Expression)new GenericLiteral("BIGINT", Long.toString(parent.getCount()))));
        ProjectNode projectNode = new ProjectNode(context.getIdAllocator().getNextId(), filterNode, Assignments.identity(parent.getOutputSymbols()));
        return Rule.Result.ofPlanNode(projectNode);
    }
}

