/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.prestosql.matching.Capture;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.plan.LimitNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import java.util.List;

public class MergeLimits
implements Rule<LimitNode> {
    private static final Capture<LimitNode> CHILD = Capture.newCapture();
    private static final Pattern<LimitNode> PATTERN = Patterns.limit().matching(limit -> !limit.isWithTies()).with(Patterns.source().matching(Patterns.limit().capturedAs(CHILD)));

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LimitNode parent, Captures captures, Rule.Context context) {
        LimitNode child = (LimitNode)captures.get(CHILD);
        if (!child.isWithTies()) {
            return Rule.Result.ofPlanNode(new LimitNode(parent.getId(), child.getSource(), Math.min(parent.getCount(), child.getCount()), parent.getTiesResolvingScheme(), parent.isPartial()));
        }
        if (parent.getCount() > child.getCount()) {
            return Rule.Result.ofPlanNode(child.replaceChildren((List<PlanNode>)ImmutableList.of((Object)parent.replaceChildren((List<PlanNode>)ImmutableList.of((Object)child.getSource())))));
        }
        return Rule.Result.ofPlanNode(parent.replaceChildren((List<PlanNode>)ImmutableList.of((Object)child.getSource())));
    }
}

