/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableSet;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.SymbolsExtractor;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.Util;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.Patterns;
import java.util.Set;

public class PruneJoinChildrenColumns
implements Rule<JoinNode> {
    private static final Pattern<JoinNode> PATTERN = Patterns.join();

    @Override
    public Pattern<JoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(JoinNode joinNode, Captures captures, Rule.Context context) {
        ImmutableSet globallyUsableInputs = ImmutableSet.builder().addAll(joinNode.getOutputSymbols()).addAll((Iterable)joinNode.getFilter().map(SymbolsExtractor::extractUnique).orElse((Set)ImmutableSet.of())).build();
        ImmutableSet leftUsableInputs = ImmutableSet.builder().addAll((Iterable)globallyUsableInputs).addAll(joinNode.getCriteria().stream().map(JoinNode.EquiJoinClause::getLeft).iterator()).addAll((Iterable)joinNode.getLeftHashSymbol().map(ImmutableSet::of).orElse(ImmutableSet.of())).build();
        ImmutableSet rightUsableInputs = ImmutableSet.builder().addAll((Iterable)globallyUsableInputs).addAll(joinNode.getCriteria().stream().map(JoinNode.EquiJoinClause::getRight).iterator()).addAll((Iterable)joinNode.getRightHashSymbol().map(ImmutableSet::of).orElse(ImmutableSet.of())).build();
        return Util.restrictChildOutputs(context.getIdAllocator(), joinNode, new Set[]{leftUsableInputs, rightUsableInputs}).map(Rule.Result::ofPlanNode).orElse(Rule.Result.empty());
    }
}

