/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.ProjectOffPushDownRule;
import io.prestosql.sql.planner.iterative.rule.Util;
import io.prestosql.sql.planner.plan.LimitNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.RowNumberNode;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class PruneRowNumberColumns
extends ProjectOffPushDownRule<RowNumberNode> {
    public PruneRowNumberColumns() {
        super(Patterns.rowNumber());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(Rule.Context context, RowNumberNode rowNumberNode, Set<Symbol> referencedOutputs) {
        if (!referencedOutputs.contains(rowNumberNode.getRowNumberSymbol())) {
            if (rowNumberNode.getMaxRowCountPerPartition().isEmpty()) {
                return Optional.of(rowNumberNode.getSource());
            }
            if (rowNumberNode.getPartitionBy().isEmpty()) {
                return Optional.of(new LimitNode(rowNumberNode.getId(), rowNumberNode.getSource(), rowNumberNode.getMaxRowCountPerPartition().get().intValue(), false));
            }
        }
        Set requiredInputs = (Set)Streams.concat((Stream[])new Stream[]{referencedOutputs.stream().filter(symbol -> !symbol.equals(rowNumberNode.getRowNumberSymbol())), rowNumberNode.getPartitionBy().stream(), rowNumberNode.getHashSymbol().stream()}).collect(ImmutableSet.toImmutableSet());
        return Util.restrictChildOutputs(context.getIdAllocator(), rowNumberNode, requiredInputs);
    }
}

