/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.ProjectOffPushDownRule;
import io.prestosql.sql.planner.iterative.rule.Util;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.TopNRowNumberNode;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class PruneTopNRowNumberColumns
extends ProjectOffPushDownRule<TopNRowNumberNode> {
    public PruneTopNRowNumberColumns() {
        super(Patterns.topNRowNumber());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(Rule.Context context, TopNRowNumberNode topNRowNumberNode, Set<Symbol> referencedOutputs) {
        Set requiredInputs = (Set)Streams.concat((Stream[])new Stream[]{referencedOutputs.stream().filter(symbol -> !symbol.equals(topNRowNumberNode.getRowNumberSymbol())), topNRowNumberNode.getPartitionBy().stream(), topNRowNumberNode.getOrderingScheme().getOrderBy().stream(), topNRowNumberNode.getHashSymbol().stream()}).collect(ImmutableSet.toImmutableSet());
        return Util.restrictChildOutputs(context.getIdAllocator(), topNRowNumberNode, requiredInputs);
    }
}

