/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.ProjectOffPushDownRule;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ValuesNode;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Row;
import io.prestosql.util.MoreLists;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class PruneValuesColumns
extends ProjectOffPushDownRule<ValuesNode> {
    public PruneValuesColumns() {
        super(Patterns.values());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(Rule.Context context, ValuesNode valuesNode, Set<Symbol> referencedOutputs) {
        if (valuesNode.getOutputSymbols().isEmpty()) {
            return Optional.empty();
        }
        List<Symbol> newOutputs = MoreLists.filteredCopy(valuesNode.getOutputSymbols(), referencedOutputs::contains);
        if (newOutputs.isEmpty()) {
            return Optional.of(new ValuesNode(valuesNode.getId(), valuesNode.getRowCount()));
        }
        Preconditions.checkState((boolean)valuesNode.getRows().isPresent(), (Object)"rows is empty");
        if (!valuesNode.getRows().get().stream().allMatch(Row.class::isInstance)) {
            return Optional.empty();
        }
        int[] mapping = new int[newOutputs.size()];
        for (int i2 = 0; i2 < mapping.length; ++i2) {
            mapping[i2] = valuesNode.getOutputSymbols().indexOf(newOutputs.get(i2));
        }
        ImmutableList.Builder rowsBuilder = ImmutableList.builder();
        for (Expression row : valuesNode.getRows().get()) {
            rowsBuilder.add((Object)new Row(Arrays.stream(mapping).mapToObj(i -> (Expression)((Row)row).getItems().get(i)).collect(Collectors.toList())));
        }
        return Optional.of(new ValuesNode(valuesNode.getId(), newOutputs, (List<Expression>)rowsBuilder.build()));
    }
}

