/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.prestosql.matching.Capture;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.ExpressionNodeInliner;
import io.prestosql.sql.planner.OrderingScheme;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.DereferencePushdown;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.planner.plan.TopNRowNumberNode;
import io.prestosql.sql.planner.plan.WindowNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PushDownDereferencesThroughTopNRowNumber
implements Rule<ProjectNode> {
    private static final Capture<TopNRowNumberNode> CHILD = Capture.newCapture();
    private final TypeAnalyzer typeAnalyzer;

    public PushDownDereferencesThroughTopNRowNumber(TypeAnalyzer typeAnalyzer) {
        this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
    }

    @Override
    public Pattern<ProjectNode> getPattern() {
        return Patterns.project().with(Patterns.source().matching(Patterns.topNRowNumber().capturedAs(CHILD)));
    }

    @Override
    public Rule.Result apply(ProjectNode projectNode, Captures captures, Rule.Context context) {
        TopNRowNumberNode topNRowNumberNode = (TopNRowNumberNode)captures.get(CHILD);
        Set dereferences = DereferencePushdown.extractDereferences(projectNode.getAssignments().getExpressions(), false);
        WindowNode.Specification specification = topNRowNumberNode.getSpecification();
        if ((dereferences = (Set)dereferences.stream().filter(expression -> {
            Symbol symbol = DereferencePushdown.getBase(expression);
            return !specification.getPartitionBy().contains(symbol) && !specification.getOrderingScheme().map(OrderingScheme::getOrderBy).orElse((List)ImmutableList.of()).contains(symbol);
        }).collect(ImmutableSet.toImmutableSet())).isEmpty()) {
            return Rule.Result.empty();
        }
        Assignments dereferenceAssignments = Assignments.of(dereferences, context.getSession(), context.getSymbolAllocator(), this.typeAnalyzer);
        Map mappings = (Map)HashBiMap.create(dereferenceAssignments.getMap()).inverse().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((Symbol)entry.getValue()).toSymbolReference()));
        Assignments newAssignments = projectNode.getAssignments().rewrite(expression -> ExpressionNodeInliner.replaceExpression(expression, mappings));
        return Rule.Result.ofPlanNode(new ProjectNode(context.getIdAllocator().getNextId(), topNRowNumberNode.replaceChildren((List<PlanNode>)ImmutableList.of((Object)new ProjectNode(context.getIdAllocator().getNextId(), topNRowNumberNode.getSource(), Assignments.builder().putIdentities(topNRowNumberNode.getSource().getOutputSymbols()).putAll(dereferenceAssignments).build()))), newAssignments));
    }
}

