/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.prestosql.matching.Capture;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.optimizations.QueryCardinalityUtil;
import io.prestosql.sql.planner.plan.LimitNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.UnionNode;
import java.util.List;

public class PushLimitThroughUnion
implements Rule<LimitNode> {
    private static final Capture<UnionNode> CHILD = Capture.newCapture();
    private static final Pattern<LimitNode> PATTERN = Patterns.limit().matching(limit -> !limit.isWithTies()).with(Patterns.source().matching(Patterns.union().capturedAs(CHILD)));

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LimitNode parent, Captures captures, Rule.Context context) {
        UnionNode unionNode = (UnionNode)captures.get(CHILD);
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean shouldApply = false;
        for (PlanNode source : unionNode.getSources()) {
            if (QueryCardinalityUtil.isAtMost(source, context.getLookup(), parent.getCount())) {
                builder.add((Object)source);
                continue;
            }
            shouldApply = true;
            builder.add((Object)new LimitNode(context.getIdAllocator().getNextId(), source, parent.getCount(), true));
        }
        if (!shouldApply) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(parent.replaceChildren((List<PlanNode>)ImmutableList.of((Object)unionNode.replaceChildren((List<PlanNode>)builder.build()))));
    }
}

