/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.prestosql.Session;
import io.prestosql.SystemSessionProperties;
import io.prestosql.matching.Capture;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.TableHandle;
import io.prestosql.metadata.TableLayoutResult;
import io.prestosql.operator.scalar.TryFunction;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.Constraint;
import io.prestosql.spi.connector.ConstraintApplicationResult;
import io.prestosql.spi.predicate.NullableValue;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.TypeOperators;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.planner.DomainTranslator;
import io.prestosql.sql.planner.ExpressionInterpreter;
import io.prestosql.sql.planner.LookupSymbolResolver;
import io.prestosql.sql.planner.PlanNodeIdAllocator;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SymbolsExtractor;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import io.prestosql.sql.planner.plan.ValuesNode;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.NullLiteral;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class PushPredicateIntoTableScan
implements Rule<FilterNode> {
    private static final Capture<TableScanNode> TABLE_SCAN = Capture.newCapture();
    private static final Pattern<FilterNode> PATTERN = Patterns.filter().with(Patterns.source().matching(Patterns.tableScan().capturedAs(TABLE_SCAN)));
    private final Metadata metadata;
    private final TypeOperators typeOperators;
    private final TypeAnalyzer typeAnalyzer;
    private final DomainTranslator domainTranslator;

    public PushPredicateIntoTableScan(Metadata metadata, TypeOperators typeOperators, TypeAnalyzer typeAnalyzer) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.typeOperators = Objects.requireNonNull(typeOperators, "typeOperators is null");
        this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        this.domainTranslator = new DomainTranslator(metadata);
    }

    @Override
    public Pattern<FilterNode> getPattern() {
        return PATTERN;
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isAllowPushdownIntoConnectors(session);
    }

    @Override
    public Rule.Result apply(FilterNode filterNode, Captures captures, Rule.Context context) {
        TableScanNode tableScan = (TableScanNode)captures.get(TABLE_SCAN);
        Optional<PlanNode> rewritten = PushPredicateIntoTableScan.pushFilterIntoTableScan(tableScan, filterNode.getPredicate(), false, context.getSession(), context.getSymbolAllocator().getTypes(), context.getIdAllocator(), this.metadata, this.typeOperators, this.typeAnalyzer, this.domainTranslator);
        if (rewritten.isEmpty() || this.arePlansSame(filterNode, tableScan, rewritten.get())) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(rewritten.get());
    }

    private boolean arePlansSame(FilterNode filter, TableScanNode tableScan, PlanNode rewritten) {
        if (!(rewritten instanceof FilterNode)) {
            return false;
        }
        FilterNode rewrittenFilter = (FilterNode)rewritten;
        if (!Objects.equals(filter.getPredicate(), rewrittenFilter.getPredicate())) {
            return false;
        }
        if (!(rewrittenFilter.getSource() instanceof TableScanNode)) {
            return false;
        }
        TableScanNode rewrittenTableScan = (TableScanNode)rewrittenFilter.getSource();
        return Objects.equals(tableScan.getEnforcedConstraint(), rewrittenTableScan.getEnforcedConstraint()) && Objects.equals(tableScan.getTable(), rewrittenTableScan.getTable());
    }

    public static Optional<PlanNode> pushFilterIntoTableScan(TableScanNode node, Expression predicate, boolean pruneWithPredicateExpression, Session session, TypeProvider types, PlanNodeIdAllocator idAllocator, Metadata metadata, TypeOperators typeOperators, TypeAnalyzer typeAnalyzer, DomainTranslator domainTranslator) {
        TupleDomain<ColumnHandle> remainingFilter;
        TableHandle newTable;
        Constraint constraint;
        Expression deterministicPredicate = ExpressionUtils.filterDeterministicConjuncts(metadata, predicate);
        Expression nonDeterministicPredicate = ExpressionUtils.filterNonDeterministicConjuncts(metadata, predicate);
        DomainTranslator.ExtractionResult decomposedPredicate = DomainTranslator.fromPredicate(metadata, typeOperators, session, deterministicPredicate, types);
        TupleDomain newDomain = decomposedPredicate.getTupleDomain().transform(node.getAssignments()::get).intersect(node.getEnforcedConstraint());
        ImmutableBiMap assignments = ImmutableBiMap.copyOf(node.getAssignments()).inverse();
        if (pruneWithPredicateExpression && !BooleanLiteral.TRUE_LITERAL.equals((Object)decomposedPredicate.getRemainingExpression())) {
            Expression[] expressionArray = new Expression[2];
            expressionArray[0] = deterministicPredicate;
            expressionArray[1] = domainTranslator.toPredicate((TupleDomain<Symbol>)newDomain.simplify().transform(((Map)assignments)::get));
            LayoutConstraintEvaluator evaluator = new LayoutConstraintEvaluator(metadata, typeAnalyzer, session, types, node.getAssignments(), ExpressionUtils.combineConjuncts(metadata, expressionArray));
            constraint = new Constraint(newDomain, x$0 -> evaluator.isCandidate((Map<ColumnHandle, NullableValue>)x$0), evaluator.getArguments());
        } else {
            constraint = new Constraint(newDomain);
        }
        if (!metadata.usesLegacyTableLayouts(session, node.getTable())) {
            if (constraint.predicate().isEmpty() && newDomain.contains(node.getEnforcedConstraint())) {
                Expression resultingPredicate = PushPredicateIntoTableScan.createResultingPredicate(metadata, (Expression)BooleanLiteral.TRUE_LITERAL, nonDeterministicPredicate, decomposedPredicate.getRemainingExpression());
                if (!BooleanLiteral.TRUE_LITERAL.equals((Object)resultingPredicate)) {
                    return Optional.of(new FilterNode(idAllocator.getNextId(), node, resultingPredicate));
                }
                return Optional.of(node);
            }
            if (newDomain.isNone()) {
                return Optional.of(new ValuesNode(node.getId(), node.getOutputSymbols(), (List<Expression>)ImmutableList.of()));
            }
            Optional<ConstraintApplicationResult<TableHandle>> result = metadata.applyFilter(session, node.getTable(), constraint);
            if (result.isEmpty()) {
                return Optional.empty();
            }
            newTable = (TableHandle)result.get().getHandle();
            if (metadata.getTableProperties(session, newTable).getPredicate().isNone()) {
                return Optional.of(new ValuesNode(node.getId(), node.getOutputSymbols(), (List<Expression>)ImmutableList.of()));
            }
            remainingFilter = result.get().getRemainingFilter();
        } else {
            Optional<TableLayoutResult> layout = metadata.getLayout(session, node.getTable(), constraint, Optional.of((Set)node.getOutputSymbols().stream().map(node.getAssignments()::get).collect(ImmutableSet.toImmutableSet())));
            if (layout.isEmpty() || layout.get().getTableProperties().getPredicate().isNone()) {
                return Optional.of(new ValuesNode(node.getId(), node.getOutputSymbols(), (List<Expression>)ImmutableList.of()));
            }
            newTable = layout.get().getNewTableHandle();
            remainingFilter = layout.get().getUnenforcedConstraint();
        }
        TableScanNode tableScan = new TableScanNode(node.getId(), newTable, node.getOutputSymbols(), node.getAssignments(), TableLayoutResult.computeEnforced((TupleDomain<ColumnHandle>)newDomain, remainingFilter), node.isForDelete());
        Expression resultingPredicate = PushPredicateIntoTableScan.createResultingPredicate(metadata, domainTranslator.toPredicate((TupleDomain<Symbol>)remainingFilter.transform(((Map)assignments)::get)), nonDeterministicPredicate, decomposedPredicate.getRemainingExpression());
        if (!BooleanLiteral.TRUE_LITERAL.equals((Object)resultingPredicate)) {
            return Optional.of(new FilterNode(idAllocator.getNextId(), tableScan, resultingPredicate));
        }
        return Optional.of(tableScan);
    }

    static Expression createResultingPredicate(Metadata metadata, Expression unenforcedConstraints, Expression nonDeterministicPredicate, Expression remainingDecomposedPredicate) {
        return ExpressionUtils.combineConjuncts(metadata, unenforcedConstraints, nonDeterministicPredicate, remainingDecomposedPredicate);
    }

    private static class LayoutConstraintEvaluator {
        private final Map<Symbol, ColumnHandle> assignments;
        private final ExpressionInterpreter evaluator;
        private final Set<ColumnHandle> arguments;

        public LayoutConstraintEvaluator(Metadata metadata, TypeAnalyzer typeAnalyzer, Session session, TypeProvider types, Map<Symbol, ColumnHandle> assignments, Expression expression) {
            this.assignments = assignments;
            this.evaluator = ExpressionInterpreter.expressionOptimizer(expression, metadata, session, typeAnalyzer.getTypes(session, types, expression));
            this.arguments = (Set)SymbolsExtractor.extractUnique(expression).stream().map(assignments::get).collect(ImmutableSet.toImmutableSet());
        }

        public Set<ColumnHandle> getArguments() {
            return this.arguments;
        }

        private boolean isCandidate(Map<ColumnHandle, NullableValue> bindings) {
            if (Sets.intersection(bindings.keySet(), this.arguments).isEmpty()) {
                return true;
            }
            LookupSymbolResolver inputs = new LookupSymbolResolver(this.assignments, bindings);
            Boolean optimized = TryFunction.evaluate(() -> this.evaluator.optimize(inputs), true);
            return !Boolean.FALSE.equals(optimized) && optimized != null && !(optimized instanceof NullLiteral);
        }
    }
}

