/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.optimizations.QueryCardinalityUtil;
import io.prestosql.sql.planner.plan.LimitNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.ValuesNode;
import io.prestosql.sql.tree.Expression;
import java.util.List;

public class RemoveRedundantLimit
implements Rule<LimitNode> {
    private static final Pattern<LimitNode> PATTERN = Patterns.limit();

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LimitNode limit, Captures captures, Rule.Context context) {
        if (limit.getCount() == 0L) {
            return Rule.Result.ofPlanNode(new ValuesNode(limit.getId(), limit.getOutputSymbols(), (List<Expression>)ImmutableList.of()));
        }
        if (QueryCardinalityUtil.isAtMost(limit.getSource(), context.getLookup(), limit.getCount())) {
            return Rule.Result.ofPlanNode(limit.getSource());
        }
        return Rule.Result.empty();
    }
}

