/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.prestosql.SystemSessionProperties;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.planner.FunctionCallBuilder;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.LongLiteral;
import io.prestosql.sql.tree.QualifiedName;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class RewriteSpatialPartitioningAggregation
implements Rule<AggregationNode> {
    private static final TypeSignature GEOMETRY_TYPE_SIGNATURE = new TypeSignature("Geometry", new TypeSignatureParameter[0]);
    private static final String NAME = "spatial_partitioning";
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation().matching(RewriteSpatialPartitioningAggregation::hasSpatialPartitioningAggregation);
    private final Metadata metadata;

    public RewriteSpatialPartitioningAggregation(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    private static boolean hasSpatialPartitioningAggregation(AggregationNode aggregationNode) {
        return aggregationNode.getAggregations().values().stream().anyMatch(aggregation -> aggregation.getResolvedFunction().getSignature().getName().equals(NAME) && aggregation.getArguments().size() == 1);
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode node, Captures captures, Rule.Context context) {
        ResolvedFunction spatialPartitioningFunction = this.metadata.resolveFunction(QualifiedName.of((String)NAME), TypeSignatureProvider.fromTypeSignatures(GEOMETRY_TYPE_SIGNATURE, IntegerType.INTEGER.getTypeSignature()));
        ResolvedFunction stEnvelopeFunction = this.metadata.resolveFunction(QualifiedName.of((String)"ST_Envelope"), TypeSignatureProvider.fromTypeSignatures(GEOMETRY_TYPE_SIGNATURE));
        ImmutableMap.Builder aggregations = ImmutableMap.builder();
        Symbol partitionCountSymbol = context.getSymbolAllocator().newSymbol("partition_count", (Type)IntegerType.INTEGER);
        ImmutableMap.Builder envelopeAssignments = ImmutableMap.builder();
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : node.getAggregations().entrySet()) {
            AggregationNode.Aggregation aggregation = entry.getValue();
            String name = aggregation.getResolvedFunction().getSignature().getName();
            if (name.equals(NAME) && aggregation.getArguments().size() == 1) {
                Expression geometry = (Expression)Iterables.getOnlyElement(aggregation.getArguments());
                Symbol envelopeSymbol = context.getSymbolAllocator().newSymbol("envelope", this.metadata.getType(GEOMETRY_TYPE_SIGNATURE));
                if (this.isStEnvelopeFunctionCall(geometry, stEnvelopeFunction)) {
                    envelopeAssignments.put((Object)envelopeSymbol, (Object)geometry);
                } else {
                    envelopeAssignments.put((Object)envelopeSymbol, (Object)new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"ST_Envelope")).addArgument(GEOMETRY_TYPE_SIGNATURE, geometry).build());
                }
                aggregations.put((Object)entry.getKey(), (Object)new AggregationNode.Aggregation(spatialPartitioningFunction, (List<Expression>)ImmutableList.of((Object)envelopeSymbol.toSymbolReference(), (Object)partitionCountSymbol.toSymbolReference()), false, Optional.empty(), Optional.empty(), aggregation.getMask()));
                continue;
            }
            aggregations.put(entry);
        }
        return Rule.Result.ofPlanNode(new AggregationNode(node.getId(), new ProjectNode(context.getIdAllocator().getNextId(), node.getSource(), Assignments.builder().putIdentities(node.getSource().getOutputSymbols()).put(partitionCountSymbol, (Expression)new LongLiteral(Integer.toString(SystemSessionProperties.getHashPartitionCount(context.getSession())))).putAll((Map<Symbol, ? extends Expression>)envelopeAssignments.build()).build()), (Map<Symbol, AggregationNode.Aggregation>)aggregations.build(), node.getGroupingSets(), node.getPreGroupedSymbols(), node.getStep(), node.getHashSymbol(), node.getGroupIdSymbol()));
    }

    private boolean isStEnvelopeFunctionCall(Expression expression, ResolvedFunction stEnvelopeFunction) {
        if (!(expression instanceof FunctionCall)) {
            return false;
        }
        FunctionCall functionCall = (FunctionCall)expression;
        return this.metadata.decodeFunction(functionCall.getName()).getFunctionId().equals(stEnvelopeFunction.getFunctionId());
    }
}

