/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.prestosql.matching.Capture;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.metadata.BoundSignature;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Literal;
import io.prestosql.sql.tree.NullLiteral;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.SymbolReference;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SimplifyCountOverConstant
implements Rule<AggregationNode> {
    private static final Capture<ProjectNode> CHILD = Capture.newCapture();
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation().with(Patterns.source().matching(Patterns.project().capturedAs(CHILD)));
    private final ResolvedFunction countFunction;

    public SimplifyCountOverConstant(Metadata metadata) {
        this.countFunction = metadata.resolveFunction(QualifiedName.of((String)"count"), (List<TypeSignatureProvider>)ImmutableList.of());
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode parent, Captures captures, Rule.Context context) {
        ProjectNode child = (ProjectNode)captures.get(CHILD);
        boolean changed = false;
        LinkedHashMap<Symbol, AggregationNode.Aggregation> aggregations = new LinkedHashMap<Symbol, AggregationNode.Aggregation>(parent.getAggregations());
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : parent.getAggregations().entrySet()) {
            Symbol symbol = entry.getKey();
            AggregationNode.Aggregation aggregation = entry.getValue();
            if (!SimplifyCountOverConstant.isCountOverConstant(aggregation, child.getAssignments())) continue;
            changed = true;
            aggregations.put(symbol, new AggregationNode.Aggregation(this.countFunction, (List<Expression>)ImmutableList.of(), false, Optional.empty(), Optional.empty(), aggregation.getMask()));
        }
        if (!changed) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(new AggregationNode(parent.getId(), child, aggregations, parent.getGroupingSets(), (List<Symbol>)ImmutableList.of(), parent.getStep(), parent.getHashSymbol(), parent.getGroupIdSymbol()));
    }

    private static boolean isCountOverConstant(AggregationNode.Aggregation aggregation, Assignments inputs) {
        BoundSignature signature = aggregation.getResolvedFunction().getSignature();
        if (!signature.getName().equals("count") || signature.getArgumentTypes().size() != 1) {
            return false;
        }
        Expression argument = aggregation.getArguments().get(0);
        if (argument instanceof SymbolReference) {
            argument = inputs.get(Symbol.from(argument));
        }
        return argument instanceof Literal && !(argument instanceof NullLiteral);
    }
}

