/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.optimizations;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import io.prestosql.Session;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.Signature;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.DesugarArrayConstructorRewriter;
import io.prestosql.sql.planner.DesugarLikeRewriter;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.relational.CallExpression;
import io.prestosql.sql.relational.ConstantExpression;
import io.prestosql.sql.relational.InputReferenceExpression;
import io.prestosql.sql.relational.LambdaDefinitionExpression;
import io.prestosql.sql.relational.RowExpression;
import io.prestosql.sql.relational.RowExpressionVisitor;
import io.prestosql.sql.relational.SpecialForm;
import io.prestosql.sql.relational.SqlToRowExpressionTranslator;
import io.prestosql.sql.relational.VariableReferenceExpression;
import io.prestosql.sql.tree.Expression;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ExpressionEquivalence {
    private static final Ordering<RowExpression> ROW_EXPRESSION_ORDERING = Ordering.from((Comparator)new RowExpressionComparator());
    private final Metadata metadata;
    private final TypeAnalyzer typeAnalyzer;
    private final CanonicalizationVisitor canonicalizationVisitor;

    public ExpressionEquivalence(Metadata metadata, TypeAnalyzer typeAnalyzer) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        this.canonicalizationVisitor = new CanonicalizationVisitor();
    }

    public boolean areExpressionsEquivalent(Session session, Expression leftExpression, Expression rightExpression, TypeProvider types) {
        HashMap<Symbol, Integer> symbolInput = new HashMap<Symbol, Integer>();
        int inputId = 0;
        for (Map.Entry<Symbol, Type> entry : types.allTypes().entrySet()) {
            symbolInput.put(entry.getKey(), inputId);
            ++inputId;
        }
        RowExpression leftRowExpression = this.toRowExpression(session, leftExpression, symbolInput, types);
        RowExpression rightRowExpression = this.toRowExpression(session, rightExpression, symbolInput, types);
        RowExpression canonicalizedLeft = leftRowExpression.accept(this.canonicalizationVisitor, null);
        RowExpression canonicalizedRight = rightRowExpression.accept(this.canonicalizationVisitor, null);
        return canonicalizedLeft.equals(canonicalizedRight);
    }

    private RowExpression toRowExpression(Session session, Expression expression, Map<Symbol, Integer> symbolInput, TypeProvider types) {
        expression = DesugarLikeRewriter.rewrite(expression, session, this.metadata, this.typeAnalyzer, types);
        expression = DesugarArrayConstructorRewriter.rewrite(expression, session, this.metadata, this.typeAnalyzer, types);
        return SqlToRowExpressionTranslator.translate(expression, this.typeAnalyzer.getTypes(session, types, expression), symbolInput, this.metadata, session, false);
    }

    private static <T> List<T> swapPair(List<T> pair) {
        Objects.requireNonNull(pair, "pair is null");
        Preconditions.checkArgument((pair.size() == 2 ? 1 : 0) != 0, (Object)"Expected pair to have two elements");
        return ImmutableList.of(pair.get(1), pair.get(0));
    }

    private static class ListComparator<T>
    implements Comparator<List<T>> {
        private final Comparator<T> elementComparator;

        public ListComparator(Comparator<T> elementComparator) {
            this.elementComparator = Objects.requireNonNull(elementComparator, "elementComparator is null");
        }

        @Override
        public int compare(List<T> left, List<T> right) {
            int compareLength = Integer.min(left.size(), right.size());
            for (int i = 0; i < compareLength; ++i) {
                int result = this.elementComparator.compare(left.get(i), right.get(i));
                if (result == 0) continue;
                return result;
            }
            return Integer.compare(left.size(), right.size());
        }
    }

    private static class RowExpressionComparator
    implements Comparator<RowExpression> {
        private final Comparator<Object> classComparator = Ordering.arbitrary();
        private final ListComparator<RowExpression> argumentComparator = new ListComparator<RowExpression>(this);

        private RowExpressionComparator() {
        }

        @Override
        public int compare(RowExpression left, RowExpression right) {
            int result = this.classComparator.compare(left.getClass(), right.getClass());
            if (result != 0) {
                return result;
            }
            if (left instanceof CallExpression) {
                CallExpression leftCall = (CallExpression)left;
                CallExpression rightCall = (CallExpression)right;
                return ComparisonChain.start().compare((Comparable)((Object)leftCall.getResolvedFunction().toString()), (Comparable)((Object)rightCall.getResolvedFunction().toString())).compare(leftCall.getArguments(), rightCall.getArguments(), this.argumentComparator).result();
            }
            if (left instanceof SpecialForm) {
                SpecialForm leftForm = (SpecialForm)left;
                SpecialForm rightForm = (SpecialForm)right;
                return ComparisonChain.start().compare((Comparable)((Object)leftForm.getForm()), (Comparable)((Object)rightForm.getForm())).compare(leftForm.getArguments(), rightForm.getArguments(), this.argumentComparator).result();
            }
            if (left instanceof ConstantExpression) {
                ConstantExpression leftConstant = (ConstantExpression)left;
                ConstantExpression rightConstant = (ConstantExpression)right;
                result = leftConstant.getType().getTypeSignature().toString().compareTo(right.getType().getTypeSignature().toString());
                if (result != 0) {
                    return result;
                }
                Object leftValue = leftConstant.getValue();
                Object rightValue = rightConstant.getValue();
                if (leftValue == null) {
                    if (rightValue == null) {
                        return 0;
                    }
                    return -1;
                }
                if (rightValue == null) {
                    return 1;
                }
                Class javaType = leftConstant.getType().getJavaType();
                if (javaType == Boolean.TYPE) {
                    return ((Boolean)leftValue).compareTo((Boolean)rightValue);
                }
                if (javaType == Byte.TYPE || javaType == Short.TYPE || javaType == Integer.TYPE || javaType == Long.TYPE) {
                    return Long.compare(((Number)leftValue).longValue(), ((Number)rightValue).longValue());
                }
                if (javaType == Float.TYPE || javaType == Double.TYPE) {
                    return Double.compare(((Number)leftValue).doubleValue(), ((Number)rightValue).doubleValue());
                }
                if (leftValue instanceof Comparable) {
                    try {
                        return ((Comparable)leftValue).compareTo(rightValue);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                return -1;
            }
            if (left instanceof InputReferenceExpression) {
                return Integer.compare(((InputReferenceExpression)left).getField(), ((InputReferenceExpression)right).getField());
            }
            if (left instanceof LambdaDefinitionExpression) {
                LambdaDefinitionExpression leftLambda = (LambdaDefinitionExpression)left;
                LambdaDefinitionExpression rightLambda = (LambdaDefinitionExpression)right;
                return ComparisonChain.start().compare(leftLambda.getArgumentTypes(), rightLambda.getArgumentTypes(), new ListComparator<Type>(Comparator.comparing(Object::toString))).compare(leftLambda.getArguments(), rightLambda.getArguments(), new ListComparator(Comparator.naturalOrder())).compare((Object)leftLambda.getBody(), (Object)rightLambda.getBody(), (Comparator)this).result();
            }
            if (left instanceof VariableReferenceExpression) {
                VariableReferenceExpression leftVariableReference = (VariableReferenceExpression)left;
                VariableReferenceExpression rightVariableReference = (VariableReferenceExpression)right;
                return ComparisonChain.start().compare((Comparable)((Object)leftVariableReference.getName()), (Comparable)((Object)rightVariableReference.getName())).compare((Object)leftVariableReference.getType(), (Object)rightVariableReference.getType(), Comparator.comparing(Object::toString)).result();
            }
            throw new IllegalArgumentException("Unsupported RowExpression type " + left.getClass().getSimpleName());
        }
    }

    private static class CanonicalizationVisitor
    implements RowExpressionVisitor<RowExpression, Void> {
        @Override
        public RowExpression visitCall(CallExpression call, Void context) {
            String callName = (call = new CallExpression(call.getResolvedFunction(), (List)call.getArguments().stream().map(expression -> expression.accept(this, context)).collect(ImmutableList.toImmutableList()))).getResolvedFunction().getSignature().getName();
            if (callName.equals(Signature.mangleOperatorName(OperatorType.EQUAL)) || callName.equals(Signature.mangleOperatorName(OperatorType.IS_DISTINCT_FROM))) {
                return new CallExpression(call.getResolvedFunction(), ROW_EXPRESSION_ORDERING.sortedCopy(call.getArguments()));
            }
            return call;
        }

        @Override
        public RowExpression visitSpecialForm(SpecialForm specialForm, Void context) {
            if ((specialForm = new SpecialForm(specialForm.getForm(), specialForm.getType(), (List)specialForm.getArguments().stream().map(expression -> expression.accept(this, context)).collect(ImmutableList.toImmutableList()), specialForm.getFunctionDependencies())).getForm() == SpecialForm.Form.AND || specialForm.getForm() == SpecialForm.Form.OR) {
                List<RowExpression> flattenedArguments = CanonicalizationVisitor.flattenNestedCallArgs(specialForm);
                ImmutableSet distinctArguments = ImmutableSet.copyOf(flattenedArguments);
                if (distinctArguments.size() == 1) {
                    return (RowExpression)Iterables.getOnlyElement((Iterable)distinctArguments);
                }
                List sortedArguments = ROW_EXPRESSION_ORDERING.sortedCopy((Iterable)distinctArguments);
                return new SpecialForm(specialForm.getForm(), (Type)BooleanType.BOOLEAN, sortedArguments, specialForm.getFunctionDependencies());
            }
            return specialForm;
        }

        public static List<RowExpression> flattenNestedCallArgs(SpecialForm specialForm) {
            SpecialForm.Form form = specialForm.getForm();
            ImmutableList.Builder newArguments = ImmutableList.builder();
            for (RowExpression argument : specialForm.getArguments()) {
                if (argument instanceof SpecialForm && form == ((SpecialForm)argument).getForm()) {
                    newArguments.addAll(CanonicalizationVisitor.flattenNestedCallArgs((SpecialForm)argument));
                    continue;
                }
                newArguments.add((Object)argument);
            }
            return newArguments.build();
        }

        @Override
        public RowExpression visitConstant(ConstantExpression constant, Void context) {
            return constant;
        }

        @Override
        public RowExpression visitInputReference(InputReferenceExpression node, Void context) {
            return node;
        }

        @Override
        public RowExpression visitLambda(LambdaDefinitionExpression lambda, Void context) {
            return new LambdaDefinitionExpression(lambda.getArgumentTypes(), lambda.getArguments(), lambda.getBody().accept(this, context));
        }

        @Override
        public RowExpression visitVariableReference(VariableReferenceExpression reference, Void context) {
            return reference;
        }
    }
}

