/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.prestosql.sql.planner.OrderingScheme;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.PlanVisitor;
import java.util.List;
import java.util.Objects;

public class SortNode
extends PlanNode {
    private final PlanNode source;
    private final OrderingScheme orderingScheme;
    private final boolean partial;

    @JsonCreator
    public SortNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="orderingScheme") OrderingScheme orderingScheme, @JsonProperty(value="partial") boolean partial) {
        super(id);
        Objects.requireNonNull(source, "source is null");
        Objects.requireNonNull(orderingScheme, "orderingScheme is null");
        this.source = source;
        this.orderingScheme = orderingScheme;
        this.partial = partial;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty(value="source")
    public PlanNode getSource() {
        return this.source;
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.source.getOutputSymbols();
    }

    @JsonProperty
    public boolean isPartial() {
        return this.partial;
    }

    @JsonProperty(value="orderingScheme")
    public OrderingScheme getOrderingScheme() {
        return this.orderingScheme;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitSort(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new SortNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.orderingScheme, this.partial);
    }
}

