/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import io.prestosql.spi.statistics.ColumnStatisticMetadata;
import io.prestosql.spi.statistics.ColumnStatisticType;
import io.prestosql.spi.statistics.TableStatisticType;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class StatisticAggregationsDescriptor<T> {
    private final Map<String, T> grouping;
    private final Map<TableStatisticType, T> tableStatistics;
    private final Map<ColumnStatisticMetadata, T> columnStatistics;

    public static <T> StatisticAggregationsDescriptor<T> empty() {
        return StatisticAggregationsDescriptor.builder().build();
    }

    @JsonCreator
    public StatisticAggregationsDescriptor(@JsonProperty(value="grouping") Map<String, T> grouping, @JsonProperty(value="tableStatistics") Map<TableStatisticType, T> tableStatistics, @JsonProperty(value="columnStatistics") Map<ColumnStatisticMetadata, T> columnStatistics) {
        this.grouping = ImmutableMap.copyOf(Objects.requireNonNull(grouping, "grouping is null"));
        this.tableStatistics = ImmutableMap.copyOf(Objects.requireNonNull(tableStatistics, "tableStatistics is null"));
        this.columnStatistics = ImmutableMap.copyOf(Objects.requireNonNull(columnStatistics, "columnStatistics is null"));
    }

    @JsonProperty
    public Map<String, T> getGrouping() {
        return this.grouping;
    }

    @JsonProperty
    public Map<TableStatisticType, T> getTableStatistics() {
        return this.tableStatistics;
    }

    @JsonProperty
    @JsonSerialize(keyUsing=ColumnStatisticMetadataKeySerializer.class)
    @JsonDeserialize(keyUsing=ColumnStatisticMetadataKeyDeserializer.class)
    public Map<ColumnStatisticMetadata, T> getColumnStatistics() {
        return this.columnStatistics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatisticAggregationsDescriptor that = (StatisticAggregationsDescriptor)o;
        return Objects.equals(this.grouping, that.grouping) && Objects.equals(this.tableStatistics, that.tableStatistics) && Objects.equals(this.columnStatistics, that.columnStatistics);
    }

    public int hashCode() {
        return Objects.hash(this.grouping, this.tableStatistics, this.columnStatistics);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("grouping", this.grouping).add("tableStatistics", this.tableStatistics).add("columnStatistics", this.columnStatistics).toString();
    }

    public static <B> Builder<B> builder() {
        return new Builder();
    }

    public <T2> StatisticAggregationsDescriptor<T2> map(Function<T, T2> mapper) {
        return new StatisticAggregationsDescriptor<T2>(StatisticAggregationsDescriptor.map(this.getGrouping(), mapper), StatisticAggregationsDescriptor.map(this.getTableStatistics(), mapper), StatisticAggregationsDescriptor.map(this.getColumnStatistics(), mapper));
    }

    private static <K, V1, V2> Map<K, V2> map(Map<K, V1> input, Function<V1, V2> mapper) {
        return (Map)input.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> mapper.apply(entry.getValue())));
    }

    public static class ColumnStatisticMetadataKeyDeserializer
    extends KeyDeserializer {
        public ColumnStatisticMetadata deserializeKey(String key, DeserializationContext ctxt) {
            return ColumnStatisticMetadataKeyDeserializer.deserialize(Objects.requireNonNull(key, "key is null"));
        }

        @VisibleForTesting
        static ColumnStatisticMetadata deserialize(String value) {
            int separatorIndex = value.indexOf(58);
            Preconditions.checkArgument((separatorIndex >= 0 ? 1 : 0) != 0, (String)"separator not found: %s", (Object)value);
            String statisticType = value.substring(0, separatorIndex);
            String column = value.substring(separatorIndex + 1);
            return new ColumnStatisticMetadata(column, ColumnStatisticType.valueOf((String)statisticType));
        }
    }

    public static class ColumnStatisticMetadataKeySerializer
    extends JsonSerializer<ColumnStatisticMetadata> {
        public void serialize(ColumnStatisticMetadata value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeFieldName(ColumnStatisticMetadataKeySerializer.serialize((ColumnStatisticMetadata)Verify.verifyNotNull((Object)value, (String)"value is null", (Object[])new Object[0])));
        }

        @VisibleForTesting
        static String serialize(ColumnStatisticMetadata value) {
            return value.getStatisticType().name() + ":" + value.getColumnName();
        }
    }

    public static class Builder<T> {
        private final ImmutableMap.Builder<String, T> grouping = ImmutableMap.builder();
        private final ImmutableMap.Builder<TableStatisticType, T> tableStatistics = ImmutableMap.builder();
        private final ImmutableMap.Builder<ColumnStatisticMetadata, T> columnStatistics = ImmutableMap.builder();

        public void addGrouping(String column, T key) {
            this.grouping.put((Object)column, key);
        }

        public void addTableStatistic(TableStatisticType type, T key) {
            this.tableStatistics.put((Object)type, key);
        }

        public void addColumnStatistic(ColumnStatisticMetadata statisticMetadata, T key) {
            this.columnStatistics.put((Object)statisticMetadata, key);
        }

        public StatisticAggregationsDescriptor<T> build() {
            return new StatisticAggregationsDescriptor(this.grouping.build(), this.tableStatistics.build(), this.columnStatistics.build());
        }
    }
}

