/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.relational.optimizer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.Session;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.Signature;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.InterpretedFunctionInvoker;
import io.prestosql.sql.relational.CallExpression;
import io.prestosql.sql.relational.ConstantExpression;
import io.prestosql.sql.relational.Expressions;
import io.prestosql.sql.relational.InputReferenceExpression;
import io.prestosql.sql.relational.LambdaDefinitionExpression;
import io.prestosql.sql.relational.RowExpression;
import io.prestosql.sql.relational.RowExpressionVisitor;
import io.prestosql.sql.relational.SpecialForm;
import io.prestosql.sql.relational.VariableReferenceExpression;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.type.JsonType;
import java.util.List;
import java.util.stream.Collectors;

public class ExpressionOptimizer {
    private final Metadata metadata;
    private final ConnectorSession session;

    public ExpressionOptimizer(Metadata metadata, Session session) {
        this.metadata = metadata;
        this.session = session.toConnectorSession();
    }

    public RowExpression optimize(RowExpression expression) {
        return expression.accept(new Visitor(), null);
    }

    private class Visitor
    implements RowExpressionVisitor<RowExpression, Void> {
        private Visitor() {
        }

        @Override
        public RowExpression visitInputReference(InputReferenceExpression reference, Void context) {
            return reference;
        }

        @Override
        public RowExpression visitConstant(ConstantExpression literal, Void context) {
            return literal;
        }

        @Override
        public RowExpression visitCall(CallExpression call, Void context) {
            if (call.getResolvedFunction().getSignature().getName().equals(Signature.mangleOperatorName(OperatorType.CAST))) {
                call = this.rewriteCast(call);
            }
            List arguments = (List)call.getArguments().stream().map(argument -> argument.accept(this, context)).collect(ImmutableList.toImmutableList());
            FunctionMetadata functionMetadata = ExpressionOptimizer.this.metadata.getFunctionMetadata(call.getResolvedFunction());
            if (arguments.stream().allMatch(ConstantExpression.class::isInstance) && functionMetadata.isDeterministic()) {
                List<Object> constantArguments = arguments.stream().map(ConstantExpression.class::cast).map(ConstantExpression::getValue).collect(Collectors.toList());
                try {
                    InterpretedFunctionInvoker invoker = new InterpretedFunctionInvoker(ExpressionOptimizer.this.metadata);
                    return Expressions.constant(invoker.invoke(call.getResolvedFunction(), ExpressionOptimizer.this.session, constantArguments), call.getType());
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return Expressions.call(call.getResolvedFunction(), arguments);
        }

        @Override
        public RowExpression visitSpecialForm(SpecialForm specialForm, Void context) {
            switch (specialForm.getForm()) {
                case IF: {
                    Preconditions.checkState((specialForm.getArguments().size() == 3 ? 1 : 0) != 0, (Object)("IF function should have 3 arguments. Get " + specialForm.getArguments().size()));
                    RowExpression optimizedOperand = specialForm.getArguments().get(0).accept(this, context);
                    if (optimizedOperand instanceof ConstantExpression) {
                        ConstantExpression constantOperand = (ConstantExpression)optimizedOperand;
                        Preconditions.checkState((boolean)constantOperand.getType().equals(BooleanType.BOOLEAN), (Object)("Operand of IF function should be BOOLEAN type. Get type " + constantOperand.getType().getDisplayName()));
                        if (Boolean.TRUE.equals(constantOperand.getValue())) {
                            return specialForm.getArguments().get(1).accept(this, context);
                        }
                        return specialForm.getArguments().get(2).accept(this, context);
                    }
                    List arguments = (List)specialForm.getArguments().stream().map(argument -> argument.accept(this, null)).collect(ImmutableList.toImmutableList());
                    return new SpecialForm(specialForm.getForm(), specialForm.getType(), arguments, specialForm.getFunctionDependencies());
                }
                case BIND: {
                    Preconditions.checkState((specialForm.getArguments().size() >= 1 ? 1 : 0) != 0, (Object)(SpecialForm.Form.BIND + " function should have at least 1 argument. Got " + specialForm.getArguments().size()));
                    boolean allConstantExpression = true;
                    ImmutableList.Builder optimizedArgumentsBuilder = ImmutableList.builder();
                    for (RowExpression argument2 : specialForm.getArguments()) {
                        RowExpression optimizedArgument = argument2.accept(this, context);
                        if (!(optimizedArgument instanceof ConstantExpression)) {
                            allConstantExpression = false;
                        }
                        optimizedArgumentsBuilder.add((Object)optimizedArgument);
                    }
                    if (allConstantExpression) {
                        throw new UnsupportedOperationException();
                    }
                    return new SpecialForm(specialForm.getForm(), specialForm.getType(), (List<RowExpression>)optimizedArgumentsBuilder.build(), specialForm.getFunctionDependencies());
                }
                case NULL_IF: 
                case SWITCH: 
                case WHEN: 
                case BETWEEN: 
                case IS_NULL: 
                case COALESCE: 
                case AND: 
                case OR: 
                case IN: 
                case DEREFERENCE: 
                case ROW_CONSTRUCTOR: {
                    List arguments = (List)specialForm.getArguments().stream().map(argument -> argument.accept(this, null)).collect(ImmutableList.toImmutableList());
                    return new SpecialForm(specialForm.getForm(), specialForm.getType(), arguments, specialForm.getFunctionDependencies());
                }
            }
            throw new IllegalArgumentException("Unsupported special form " + specialForm.getForm());
        }

        @Override
        public RowExpression visitLambda(LambdaDefinitionExpression lambda, Void context) {
            return new LambdaDefinitionExpression(lambda.getArgumentTypes(), lambda.getArguments(), lambda.getBody().accept(this, context));
        }

        @Override
        public RowExpression visitVariableReference(VariableReferenceExpression reference, Void context) {
            return reference;
        }

        private CallExpression rewriteCast(CallExpression call) {
            CallExpression innerCall;
            if (call.getArguments().get(0) instanceof CallExpression && (innerCall = (CallExpression)call.getArguments().get(0)).getResolvedFunction().getSignature().getName().equals("json_parse")) {
                Preconditions.checkArgument((boolean)innerCall.getType().equals((Object)JsonType.JSON));
                Preconditions.checkArgument((innerCall.getArguments().size() == 1 ? 1 : 0) != 0);
                Type returnType = call.getType();
                if (returnType instanceof ArrayType) {
                    return Expressions.call(ExpressionOptimizer.this.metadata.getCoercion(QualifiedName.of((String)"$internal$json_string_to_array_cast"), (Type)VarcharType.VARCHAR, returnType), innerCall.getArguments());
                }
                if (returnType instanceof MapType) {
                    return Expressions.call(ExpressionOptimizer.this.metadata.getCoercion(QualifiedName.of((String)"$internal$json_string_to_map_cast"), (Type)VarcharType.VARCHAR, returnType), innerCall.getArguments());
                }
                if (returnType instanceof RowType) {
                    return Expressions.call(ExpressionOptimizer.this.metadata.getCoercion(QualifiedName.of((String)"$internal$json_string_to_row_cast"), (Type)VarcharType.VARCHAR, returnType), innerCall.getArguments());
                }
            }
            return Expressions.call(ExpressionOptimizer.this.metadata.getCoercion(call.getArguments().get(0).getType(), call.getType()), call.getArguments());
        }
    }
}

