/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.testing;

import io.prestosql.spi.type.SqlDate;
import io.prestosql.spi.type.SqlTime;
import io.prestosql.spi.type.SqlTimeWithTimeZone;
import io.prestosql.spi.type.SqlTimestamp;
import io.prestosql.spi.type.SqlTimestampWithTimeZone;
import io.prestosql.spi.type.TimeZoneKey;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;

public final class DateTimeTestingUtils {
    private DateTimeTestingUtils() {
    }

    public static SqlDate sqlDateOf(int year, int monthOfYear, int dayOfMonth) {
        return DateTimeTestingUtils.sqlDateOf(LocalDate.of(year, monthOfYear, dayOfMonth));
    }

    public static SqlDate sqlDateOf(LocalDate date) {
        return new SqlDate((int)date.getLong(ChronoField.EPOCH_DAY));
    }

    public static SqlTimeWithTimeZone sqlTimeWithTimeZoneOf(int precision, int hour, int minuteOfHour, int secondOfMinute, int nanoOfSecond, int offsetMinutes) {
        long picos = (long)(hour * 3600 + minuteOfHour * 60 + secondOfMinute) * 1000000000000L + (long)nanoOfSecond * 1000L;
        return SqlTimeWithTimeZone.newInstance((int)precision, (long)picos, (int)offsetMinutes);
    }

    public static SqlTimestampWithTimeZone sqlTimestampWithTimeZoneOf(int precision, int year, int month, int day, int hour, int minute, int second, int nanoOfSecond, TimeZoneKey timeZoneKey) {
        ZonedDateTime base = ZonedDateTime.of(year, month, day, hour, minute, second, 0, timeZoneKey.getZoneId());
        long epochMillis = base.toEpochSecond() * 1000L + (long)(nanoOfSecond / 1000000);
        int picosOfMilli = nanoOfSecond % 1000000 * 1000;
        return SqlTimestampWithTimeZone.newInstance((int)precision, (long)epochMillis, (int)picosOfMilli, (TimeZoneKey)timeZoneKey);
    }

    public static SqlTimestamp sqlTimestampOf(int precision, int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) {
        return DateTimeTestingUtils.sqlTimestampOf(precision, LocalDateTime.of(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, DateTimeTestingUtils.millisToNanos(millisOfSecond)));
    }

    public static SqlTimestamp sqlTimestampOf(int precision, LocalDateTime dateTime) {
        return DateTimeTestingUtils.sqlTimestampOf(precision, TimeUnit.DAYS.toMillis(dateTime.toLocalDate().toEpochDay()) + TimeUnit.NANOSECONDS.toMillis(dateTime.toLocalTime().toNanoOfDay()));
    }

    public static SqlTimestamp sqlTimestampOf(int precision, DateTime dateTime) {
        return DateTimeTestingUtils.sqlTimestampOf(precision, dateTime.getMillis());
    }

    @Deprecated
    public static SqlTimestamp sqlTimestampOf(DateTime dateTime) {
        return DateTimeTestingUtils.sqlTimestampOf(dateTime.getMillis());
    }

    @Deprecated
    public static SqlTimestamp sqlTimestampOf(long millis) {
        return DateTimeTestingUtils.sqlTimestampOf(3, millis);
    }

    public static SqlTimestamp sqlTimestampOf(int precision, long millis) {
        return SqlTimestamp.fromMillis((int)precision, (long)millis);
    }

    public static SqlTime sqlTimeOf(int precision, int hour, int minuteOfHour, int secondOfMinute, int nanoOfSecond) {
        return DateTimeTestingUtils.sqlTimeOf(precision, LocalTime.of(hour, minuteOfHour, secondOfMinute, nanoOfSecond));
    }

    @Deprecated
    public static SqlTime sqlTimeOf(int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) {
        LocalTime time = LocalTime.of(hourOfDay, minuteOfHour, secondOfMinute, DateTimeTestingUtils.millisToNanos(millisOfSecond));
        return DateTimeTestingUtils.sqlTimeOf(time);
    }

    @Deprecated
    public static SqlTime sqlTimeOf(LocalTime time) {
        return DateTimeTestingUtils.sqlTimeOf(3, time);
    }

    public static SqlTime sqlTimeOf(int precision, LocalTime time) {
        return SqlTime.newInstance((int)precision, (long)(time.toNanoOfDay() * 1000L));
    }

    private static int millisToNanos(int millisOfSecond) {
        return Math.toIntExact(TimeUnit.MILLISECONDS.toNanos(millisOfSecond));
    }
}

