/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.BlockBuilderStatus;
import io.prestosql.spi.block.Int128ArrayBlockBuilder;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.BlockIndex;
import io.prestosql.spi.function.BlockPosition;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.type.AbstractType;
import io.prestosql.spi.type.FixedWidthType;
import io.prestosql.spi.type.TypeOperatorDeclaration;
import io.prestosql.spi.type.TypeOperators;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import java.lang.invoke.MethodHandles;
import java.util.UUID;

public class UuidType
extends AbstractType
implements FixedWidthType {
    private static final TypeOperatorDeclaration TYPE_OPERATOR_DECLARATION = TypeOperatorDeclaration.extractOperatorDeclaration(UuidType.class, (MethodHandles.Lookup)MethodHandles.lookup(), Slice.class);
    public static final UuidType UUID = new UuidType();

    private UuidType() {
        super(new TypeSignature("uuid", new TypeSignatureParameter[0]), Slice.class);
    }

    public int getFixedSize() {
        return 16;
    }

    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new Int128ArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / this.getFixedSize()));
    }

    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, this.getFixedSize());
    }

    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new Int128ArrayBlockBuilder(null, positionCount);
    }

    public boolean isComparable() {
        return true;
    }

    public boolean isOrderable() {
        return true;
    }

    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return TYPE_OPERATOR_DECLARATION;
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        long high = Long.reverseBytes(block.getLong(position, 0));
        long low = Long.reverseBytes(block.getLong(position, 8));
        return new UUID(high, low).toString();
    }

    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            blockBuilder.writeLong(block.getLong(position, 0));
            blockBuilder.writeLong(block.getLong(position, 8));
            blockBuilder.closeEntry();
        }
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        this.writeSlice(blockBuilder, value, 0, value.length());
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        if (length != 16) {
            throw new IllegalStateException("Expected entry size to be exactly 16 but was " + length);
        }
        blockBuilder.writeLong(value.getLong(offset));
        blockBuilder.writeLong(value.getLong(offset + 8));
        blockBuilder.closeEntry();
    }

    public final Slice getSlice(Block block, int position) {
        return Slices.wrappedLongArray((long[])new long[]{block.getLong(position, 0), block.getLong(position, 8)});
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(Slice left, Slice right) {
        return UuidType.equal(left.getLong(0), left.getLong(8), right.getLong(0), right.getLong(8));
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(@BlockPosition Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Block rightBlock, @BlockIndex int rightPosition) {
        return UuidType.equal(leftBlock.getLong(leftPosition, 0), leftBlock.getLong(leftPosition, 8), rightBlock.getLong(rightPosition, 0), rightBlock.getLong(rightPosition, 8));
    }

    private static boolean equal(long leftLow, long leftHigh, long rightLow, long rightHigh) {
        return leftLow == rightLow && leftHigh == rightHigh;
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(Slice value) {
        return UuidType.xxHash64(value.getLong(0), value.getLong(8));
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(@BlockPosition Block block, @BlockIndex int position) {
        return UuidType.xxHash64(block.getLong(position, 0), block.getLong(position, 8));
    }

    private static long xxHash64(long low, long high) {
        return XxHash64.hash((long)low) ^ XxHash64.hash((long)high);
    }

    @ScalarOperator(value=OperatorType.COMPARISON)
    private static long comparisonOperator(Slice left, Slice right) {
        return UuidType.compareLittleEndian(left.getLong(0), left.getLong(8), right.getLong(0), right.getLong(8));
    }

    @ScalarOperator(value=OperatorType.COMPARISON)
    private static long comparisonOperator(@BlockPosition Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Block rightBlock, @BlockIndex int rightPosition) {
        return UuidType.compareLittleEndian(leftBlock.getLong(leftPosition, 0), leftBlock.getLong(leftPosition, 8), rightBlock.getLong(rightPosition, 0), rightBlock.getLong(rightPosition, 8));
    }

    private static int compareLittleEndian(long leftLow64le, long leftHigh64le, long rightLow64le, long rightHigh64le) {
        int compare = Long.compareUnsigned(Long.reverseBytes(leftLow64le), Long.reverseBytes(rightLow64le));
        if (compare != 0) {
            return compare;
        }
        return Long.compareUnsigned(Long.reverseBytes(leftHigh64le), Long.reverseBytes(rightHigh64le));
    }
}

