/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type.setdigest;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;

public final class SetDigestOperators {
    private SetDigestOperators() {
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="varbinary")
    public static Slice castToBinary(@SqlType(value="SetDigest") Slice slice) {
        return slice;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="SetDigest")
    public static Slice castFromBinary(@SqlType(value="varbinary") Slice slice) {
        return slice;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="HyperLogLog")
    public static Slice castToHyperLogLog(@SqlType(value="SetDigest") Slice slice) {
        Preconditions.checkArgument((slice.getByte(0) == 1 ? 1 : 0) != 0, (Object)"Legacy version of SetDigest cannot cast to HyperLogLog");
        int hllLength = slice.getInt(1);
        return Slices.wrappedBuffer((byte[])slice.getBytes(5, hllLength));
    }
}

