/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.session.db;

import com.mysql.jdbc.jdbc2.optional.MysqlDataSource;
import io.prestosql.plugin.session.db.DbSessionPropertyManagerConfig;
import io.prestosql.plugin.session.db.SessionPropertiesDao;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.sql.DataSource;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;

public class SessionPropertiesDaoProvider
implements Provider<SessionPropertiesDao> {
    private final SessionPropertiesDao dao;

    @Inject
    public SessionPropertiesDaoProvider(DbSessionPropertyManagerConfig config) {
        Objects.requireNonNull(config, "config is null");
        String url = Objects.requireNonNull(config.getConfigDbUrl(), "db url is null");
        MysqlDataSource dataSource = new MysqlDataSource();
        dataSource.setURL(url);
        Optional<String> username = Optional.ofNullable(config.getUsername());
        username.ifPresent(arg_0 -> ((MysqlDataSource)dataSource).setUser(arg_0));
        Optional<String> password = Optional.ofNullable(config.getPassword());
        password.ifPresent(arg_0 -> ((MysqlDataSource)dataSource).setPassword(arg_0));
        this.dao = (SessionPropertiesDao)Jdbi.create((DataSource)dataSource).installPlugin((JdbiPlugin)new SqlObjectPlugin()).onDemand(SessionPropertiesDao.class);
    }

    public SessionPropertiesDao get() {
        return this.dao;
    }
}

