/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.memory;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.configuration.ConfigBinder;
import io.prestosql.plugin.memory.MemoryConfig;
import io.prestosql.plugin.memory.MemoryConnector;
import io.prestosql.plugin.memory.MemoryMetadata;
import io.prestosql.plugin.memory.MemoryPageSinkProvider;
import io.prestosql.plugin.memory.MemoryPageSourceProvider;
import io.prestosql.plugin.memory.MemoryPagesStore;
import io.prestosql.plugin.memory.MemorySplitManager;
import io.prestosql.spi.NodeManager;
import io.prestosql.spi.type.TypeManager;
import java.util.Objects;

public class MemoryModule
implements Module {
    private final TypeManager typeManager;
    private final NodeManager nodeManager;

    public MemoryModule(TypeManager typeManager, NodeManager nodeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
    }

    public void configure(Binder binder) {
        binder.bind(TypeManager.class).toInstance((Object)this.typeManager);
        binder.bind(NodeManager.class).toInstance((Object)this.nodeManager);
        binder.bind(MemoryConnector.class).in(Scopes.SINGLETON);
        binder.bind(MemoryMetadata.class).in(Scopes.SINGLETON);
        binder.bind(MemorySplitManager.class).in(Scopes.SINGLETON);
        binder.bind(MemoryPagesStore.class).in(Scopes.SINGLETON);
        binder.bind(MemoryPageSourceProvider.class).in(Scopes.SINGLETON);
        binder.bind(MemoryPageSinkProvider.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(MemoryConfig.class);
    }
}

