/*
 * Decompiled with CFR 0.152.
 */
package com.cognitect.transit.impl;

import com.cognitect.transit.ArrayReader;
import com.cognitect.transit.DefaultReadHandler;
import com.cognitect.transit.MapReader;
import com.cognitect.transit.ReadHandler;
import com.cognitect.transit.Reader;
import com.cognitect.transit.SPI.ReaderSPI;
import com.cognitect.transit.TaggedValue;
import com.cognitect.transit.TransitFactory;
import com.cognitect.transit.impl.AbstractParser;
import com.cognitect.transit.impl.Cache;
import com.cognitect.transit.impl.JsonParser;
import com.cognitect.transit.impl.ListBuilderImpl;
import com.cognitect.transit.impl.MapBuilderImpl;
import com.cognitect.transit.impl.MsgpackParser;
import com.cognitect.transit.impl.ReadCache;
import com.cognitect.transit.impl.ReadHandlerMap;
import com.cognitect.transit.impl.ReadHandlers;
import com.fasterxml.jackson.core.JsonFactory;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.msgpack.MessagePack;

public class ReaderFactory {
    private static Map<Map<String, ReadHandler<?, ?>>, ReadHandlerMap> handlerCache = new Cache();

    public static Map<String, ReadHandler<?, ?>> defaultHandlers() {
        HashMap handlers = new HashMap();
        handlers.put(":", new ReadHandlers.KeywordReadHandler());
        handlers.put("$", new ReadHandlers.SymbolReadHandler());
        handlers.put("i", new ReadHandlers.IntegerReadHandler());
        handlers.put("?", new ReadHandlers.BooleanReadHandler());
        handlers.put("_", new ReadHandlers.NullReadHandler());
        handlers.put("f", new ReadHandlers.BigDecimalReadHandler());
        handlers.put("n", new ReadHandlers.BigIntegerReadHandler());
        handlers.put("d", new ReadHandlers.DoubleReadHandler());
        handlers.put("z", new ReadHandlers.SpecialNumberReadHandler());
        handlers.put("c", new ReadHandlers.CharacterReadHandler());
        handlers.put("t", new ReadHandlers.VerboseTimeReadHandler());
        handlers.put("m", new ReadHandlers.TimeReadHandler());
        handlers.put("r", new ReadHandlers.URIReadHandler());
        handlers.put("u", new ReadHandlers.UUIDReadHandler());
        handlers.put("b", new ReadHandlers.BinaryReadHandler());
        handlers.put("'", new ReadHandlers.IdentityReadHandler());
        handlers.put("set", new ReadHandlers.SetReadHandler());
        handlers.put("list", new ReadHandlers.ListReadHandler());
        handlers.put("ratio", new ReadHandlers.RatioReadHandler());
        handlers.put("cmap", new ReadHandlers.CmapReadHandler());
        handlers.put("link", new ReadHandlers.LinkReadHandler());
        return handlers;
    }

    public static DefaultReadHandler<TaggedValue<Object>> defaultDefaultHandler() {
        return new DefaultReadHandler<TaggedValue<Object>>(){

            @Override
            public TaggedValue<Object> fromRep(String tag, Object rep) {
                return TransitFactory.taggedValue(tag, rep);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, ReadHandler<?, ?>> handlerMap(Map<String, ReadHandler<?, ?>> customHandlers) {
        if (customHandlers instanceof ReadHandlerMap) {
            return customHandlers;
        }
        Class<ReaderFactory> clazz = ReaderFactory.class;
        synchronized (ReaderFactory.class) {
            ReadHandlerMap readHandlerMap = handlerCache.get(customHandlers);
            if (readHandlerMap == null) {
                readHandlerMap = new ReadHandlerMap(customHandlers);
                handlerCache.put(customHandlers, readHandlerMap);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return readHandlerMap;
        }
    }

    private static DefaultReadHandler defaultHandler(DefaultReadHandler customDefaultHandler) {
        return customDefaultHandler != null ? customDefaultHandler : ReaderFactory.defaultDefaultHandler();
    }

    public static Reader getJsonInstance(InputStream in, Map<String, ReadHandler<?, ?>> handlers, DefaultReadHandler<?> customDefaultHandler) {
        return new JsonReaderImpl(in, ReaderFactory.handlerMap(handlers), ReaderFactory.defaultHandler(customDefaultHandler));
    }

    public static Reader getMsgpackInstance(InputStream in, Map<String, ReadHandler<?, ?>> handlers, DefaultReadHandler<?> customDefaultHandler) {
        return new MsgPackReaderImpl(in, ReaderFactory.handlerMap(handlers), ReaderFactory.defaultHandler(customDefaultHandler));
    }

    private static class MsgPackReaderImpl
    extends ReaderImpl {
        public MsgPackReaderImpl(InputStream in, Map<String, ReadHandler<?, ?>> handlers, DefaultReadHandler<?> defaultHandler) {
            super(in, handlers, defaultHandler);
        }

        @Override
        protected AbstractParser createParser() {
            MessagePack mp = new MessagePack();
            return new MsgpackParser(mp.createUnpacker(this.in), this.handlers, this.defaultHandler, this.mapBuilder, this.listBuilder);
        }
    }

    private static class JsonReaderImpl
    extends ReaderImpl {
        public JsonReaderImpl(InputStream in, Map<String, ReadHandler<?, ?>> handlers, DefaultReadHandler<?> defaultHandler) {
            super(in, handlers, defaultHandler);
        }

        @Override
        protected AbstractParser createParser() {
            try {
                JsonFactory jf = new JsonFactory();
                return new JsonParser(jf.createParser(this.in), this.handlers, this.defaultHandler, this.mapBuilder, this.listBuilder);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static abstract class ReaderImpl
    implements Reader,
    ReaderSPI {
        InputStream in;
        Map<String, ReadHandler<?, ?>> handlers;
        DefaultReadHandler defaultHandler;
        MapReader<?, Map<Object, Object>, Object, Object> mapBuilder;
        ArrayReader<?, List<Object>, Object> listBuilder;
        ReadCache cache;
        AbstractParser p;
        boolean initialized = false;

        public ReaderImpl(InputStream in, Map<String, ReadHandler<?, ?>> handlers, DefaultReadHandler<?> defaultHandler) {
            this.in = in;
            this.handlers = handlers;
            this.defaultHandler = defaultHandler;
            this.cache = new ReadCache();
        }

        @Override
        public <T> T read() {
            if (!this.initialized) {
                this.initialize();
            }
            try {
                return (T)this.p.parse(this.cache.init());
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Reader setBuilders(MapReader<?, Map<Object, Object>, Object, Object> mapBuilder, ArrayReader<?, List<Object>, Object> listBuilder) {
            if (this.initialized) {
                throw new IllegalStateException("Cannot set builders after read has been called");
            }
            this.mapBuilder = mapBuilder;
            this.listBuilder = listBuilder;
            return this;
        }

        private void ensureBuilders() {
            if (this.mapBuilder == null) {
                this.mapBuilder = new MapBuilderImpl();
            }
            if (this.listBuilder == null) {
                this.listBuilder = new ListBuilderImpl();
            }
        }

        protected void initialize() {
            this.ensureBuilders();
            this.p = this.createParser();
            this.initialized = true;
        }

        protected abstract AbstractParser createParser();
    }
}

