/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.security;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImpersonationRule {
    private final Pattern originalUserPattern;
    private final Pattern newUserPattern;
    private final boolean allow;

    @JsonCreator
    public ImpersonationRule(@JsonProperty(value="original_user") @JsonAlias(value={"originalUser"}) Pattern originalUserPattern, @JsonProperty(value="new_user") @JsonAlias(value={"newUser"}) Pattern newUserPattern, @JsonProperty(value="allow") Boolean allow) {
        this.originalUserPattern = Objects.requireNonNull(originalUserPattern, "originalUserPattern is null");
        this.newUserPattern = Objects.requireNonNull(newUserPattern, "newUserPattern is null");
        this.allow = (Boolean)MoreObjects.firstNonNull((Object)allow, (Object)Boolean.TRUE);
    }

    public Optional<Boolean> match(String originalUser, String newUser) {
        Matcher matcher = this.originalUserPattern.matcher(originalUser);
        if (matcher.matches() && this.newUserPattern.matcher(newUser).matches()) {
            return Optional.of(this.allow);
        }
        return Optional.empty();
    }
}

