/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.compiler.jdk;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.codehaus.commons.compiler.AbstractJavaSourceClassLoader;
import org.codehaus.commons.compiler.jdk.ByteArrayJavaFileManager;
import org.codehaus.commons.compiler.jdk.FileInputJavaFileManager;
import org.codehaus.commons.compiler.util.Disassembler;
import org.codehaus.commons.nullanalysis.Nullable;

public class JavaSourceClassLoader
extends AbstractJavaSourceClassLoader {
    private File[] sourcePath = new File[]{new File(".")};
    @Nullable
    private String optionalCharacterEncoding;
    private boolean debuggingInfoLines;
    private boolean debuggingInfoVars;
    private boolean debuggingInfoSource;
    private Collection<String> compilerOptions = new ArrayList<String>();
    @Nullable
    private JavaCompiler compiler;
    @Nullable
    private JavaFileManager fileManager;

    public JavaSourceClassLoader() {
        this.init();
    }

    public JavaSourceClassLoader(ClassLoader parentClassLoader) {
        super(parentClassLoader);
        this.init();
    }

    private void init() {
        JavaCompiler c = ToolProvider.getSystemJavaCompiler();
        if (c == null) {
            throw new UnsupportedOperationException("JDK Java compiler not available - probably you're running a JRE, not a JDK");
        }
        this.compiler = c;
    }

    JavaFileManager getJavaFileManager() {
        if (this.fileManager != null) {
            return this.fileManager;
        }
        JavaCompiler c = this.compiler;
        if (c == null) {
            throw new IllegalStateException("System Java compiler not available");
        }
        JavaFileManager jfm = c.getStandardFileManager(null, null, null);
        jfm = new ByteArrayJavaFileManager<StandardJavaFileManager>((StandardJavaFileManager)jfm);
        jfm = new FileInputJavaFileManager(jfm, StandardLocation.SOURCE_PATH, JavaFileObject.Kind.SOURCE, this.sourcePath, this.optionalCharacterEncoding);
        this.fileManager = jfm;
        return this.fileManager;
    }

    public void setSourcePath(File[] sourcePath) {
        this.sourcePath = sourcePath;
    }

    public void setSourceFileCharacterEncoding(@Nullable String optionalCharacterEncoding) {
        this.optionalCharacterEncoding = optionalCharacterEncoding;
    }

    public void setDebuggingInfo(boolean lines, boolean vars, boolean source) {
        this.debuggingInfoLines = lines;
        this.debuggingInfoVars = vars;
        this.debuggingInfoSource = source;
    }

    public void setCompilerOptions(String[] compilerOptions) {
        this.compilerOptions = Arrays.asList(compilerOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> findClass(@Nullable String className) throws ClassNotFoundException {
        int size;
        byte[] ba;
        block15: {
            assert (className != null);
            JavaCompiler c = this.compiler;
            if (c == null) {
                throw new IllegalStateException("System Java compiler not available");
            }
            try {
                JavaFileObject classFileObject = this.getJavaFileManager().getJavaFileForInput(StandardLocation.CLASS_OUTPUT, className, JavaFileObject.Kind.CLASS);
                if (classFileObject == null) {
                    JavaFileObject sourceFileObject = this.getJavaFileManager().getJavaFileForInput(StandardLocation.SOURCE_PATH, className, JavaFileObject.Kind.SOURCE);
                    if (sourceFileObject == null) {
                        throw new DiagnosticException("Source for '" + className + "' not found");
                    }
                    ArrayList<String> options = new ArrayList<String>(this.compilerOptions);
                    options.add(this.debuggingInfoLines ? (this.debuggingInfoSource ? (this.debuggingInfoVars ? "-g" : "-g:lines,source") : (this.debuggingInfoVars ? "-g:lines,vars" : "-g:lines")) : (this.debuggingInfoSource ? (this.debuggingInfoVars ? "-g:source,vars" : "-g:source") : (this.debuggingInfoVars ? "-g:vars" : "-g:none")));
                    if (!c.getTask(null, this.getJavaFileManager(), (DiagnosticListener<? super JavaFileObject>)new DiagnosticListener<JavaFileObject>(){

                        @Override
                        public void report(@Nullable Diagnostic<? extends JavaFileObject> diagnostic) {
                            assert (diagnostic != null);
                            if (diagnostic.getKind() == Diagnostic.Kind.ERROR) {
                                throw new DiagnosticException(diagnostic);
                            }
                        }
                    }, options, null, Collections.singleton(sourceFileObject)).call().booleanValue()) {
                        throw new ClassNotFoundException(className + ": Compilation failed");
                    }
                    classFileObject = this.getJavaFileManager().getJavaFileForInput(StandardLocation.CLASS_OUTPUT, className, JavaFileObject.Kind.CLASS);
                    if (classFileObject == null) {
                        throw new ClassNotFoundException(className + ": Class file \"" + className + "\" not created by compilation");
                    }
                }
                if (classFileObject instanceof ByteArrayJavaFileManager.ByteArrayJavaFileObject) {
                    ByteArrayJavaFileManager.ByteArrayJavaFileObject bajfo = (ByteArrayJavaFileManager.ByteArrayJavaFileObject)classFileObject;
                    ba = bajfo.toByteArray();
                    size = ba.length;
                    break block15;
                }
                ba = new byte[4096];
                size = 0;
                InputStream is = classFileObject.openInputStream();
                try {
                    int res;
                    while ((res = is.read(ba, size, ba.length - size)) != -1) {
                        if ((size += res) != ba.length) continue;
                        byte[] tmp = new byte[2 * size];
                        System.arraycopy(ba, 0, tmp, 0, size);
                        ba = tmp;
                    }
                }
                finally {
                    is.close();
                }
            }
            catch (IOException ioe) {
                throw new DiagnosticException(ioe);
            }
        }
        if (Boolean.getBoolean("disasm")) {
            Disassembler.disassembleToStdout((byte[])ba);
        }
        return this.defineClass(className, ba, 0, size, this.optionalProtectionDomainFactory != null ? this.optionalProtectionDomainFactory.getProtectionDomain(JavaSourceClassLoader.getSourceResourceName(className)) : null);
    }

    private static String getSourceResourceName(String className) {
        int idx = className.lastIndexOf(46) + 1;
        if ((idx = className.indexOf(36, idx)) != -1) {
            className = className.substring(0, idx);
        }
        return className.replace('.', '/') + ".java";
    }

    private static class DiagnosticException
    extends RuntimeException {
        private static final long serialVersionUID = 5589635876875819926L;

        DiagnosticException(String message) {
            super(message);
        }

        DiagnosticException(Throwable cause) {
            super(cause);
        }

        DiagnosticException(Diagnostic<? extends JavaFileObject> diagnostic) {
            super(diagnostic.toString());
        }
    }
}

