/*
 * Decompiled with CFR 0.152.
 */
package org.fressian.impl;

import java.util.HashMap;
import org.fressian.handlers.ILookup;
import org.fressian.impl.MapLookup;

public class InheritanceLookup<V>
implements ILookup<Class, V> {
    private final ILookup<Class, V> lookup;

    public InheritanceLookup(ILookup lookup) {
        this.lookup = lookup;
    }

    public V checkBaseClasses(Class c) {
        for (Class base = c.getSuperclass(); base != Object.class; base = base.getSuperclass()) {
            V val = this.lookup.valAt(base);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    public V checkBaseInterfaces(Class c) {
        HashMap possibles = new HashMap();
        for (Class base = c; base != Object.class; base = base.getSuperclass()) {
            for (Class<?> itf : base.getInterfaces()) {
                V val = this.lookup.valAt(itf);
                if (val == null) continue;
                possibles.put(itf, val);
            }
        }
        switch (possibles.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return possibles.values().iterator().next();
            }
        }
        throw new RuntimeException("More thane one match for " + c);
    }

    @Override
    public V valAt(Class c) {
        V val = this.lookup.valAt(c);
        if (val == null) {
            val = this.checkBaseClasses(c);
        }
        if (val == null) {
            val = this.checkBaseInterfaces(c);
        }
        if (val == null) {
            val = this.lookup.valAt(Object.class);
        }
        return val;
    }

    public static void main(String[] args) {
        HashMap<Class<CharSequence>, String> m = new HashMap<Class<CharSequence>, String>();
        m.put(CharSequence.class, "boo");
        InheritanceLookup ih = new InheritanceLookup(new MapLookup(m));
        System.out.println(ih.valAt(String.class));
    }
}

