/*
 * Decompiled with CFR 0.152.
 */
package org.fressian.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Adler32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Checksum;

public class RawOutput
implements Closeable {
    private final CheckedOutputStream os;
    private int bytesWritten;
    byte[] buffer = new byte[8];

    public RawOutput(OutputStream os) {
        this.os = new CheckedOutputStream(os, new Adler32());
    }

    public void writeRawByte(int b) throws IOException {
        this.os.write(b);
        this.notifyBytesWritten(1);
    }

    public void writeRawInt16(int s) throws IOException {
        this.os.write(s >>> 8 & 0xFF);
        this.os.write(s & 0xFF);
        this.notifyBytesWritten(2);
    }

    public void writeRawInt24(int i) throws IOException {
        this.os.write(i >>> 16 & 0xFF);
        this.os.write(i >>> 8 & 0xFF);
        this.os.write(i & 0xFF);
        this.notifyBytesWritten(3);
    }

    public void writeRawInt32(int i) throws IOException {
        this.os.write(i >>> 24 & 0xFF);
        this.os.write(i >>> 16 & 0xFF);
        this.os.write(i >>> 8 & 0xFF);
        this.os.write(i & 0xFF);
        this.notifyBytesWritten(4);
    }

    public void writeRawInt40(long i) throws IOException {
        this.os.write((int)(i >>> 32) & 0xFF);
        this.os.write((int)(i >>> 24) & 0xFF);
        this.os.write((int)(i >>> 16) & 0xFF);
        this.os.write((int)(i >>> 8) & 0xFF);
        this.os.write((int)i & 0xFF);
        this.notifyBytesWritten(5);
    }

    public void writeRawInt48(long i) throws IOException {
        this.os.write((int)(i >>> 40) & 0xFF);
        this.os.write((int)(i >>> 32) & 0xFF);
        this.os.write((int)(i >>> 24) & 0xFF);
        this.os.write((int)(i >>> 16) & 0xFF);
        this.os.write((int)(i >>> 8) & 0xFF);
        this.os.write((int)i & 0xFF);
        this.notifyBytesWritten(6);
    }

    public void writeRawInt64(long l) throws IOException {
        this.buffer[0] = (byte)(l >>> 56);
        this.buffer[1] = (byte)(l >>> 48);
        this.buffer[2] = (byte)(l >>> 40);
        this.buffer[3] = (byte)(l >>> 32);
        this.buffer[4] = (byte)(l >>> 24);
        this.buffer[5] = (byte)(l >>> 16);
        this.buffer[6] = (byte)(l >>> 8);
        this.buffer[7] = (byte)(l >>> 0);
        this.os.write(this.buffer, 0, 8);
        this.notifyBytesWritten(8);
    }

    public void writeRawDouble(double d) throws IOException {
        this.writeRawInt64(Double.doubleToLongBits(d));
    }

    public void writeRawFloat(float f) throws IOException {
        this.writeRawInt32(Float.floatToIntBits(f));
    }

    public void writeRawBytes(byte[] bytes, int off, int len) throws IOException {
        this.os.write(bytes, off, len);
        this.notifyBytesWritten(len);
    }

    public Checksum getChecksum() {
        return this.os.getChecksum();
    }

    public int getBytesWritten() {
        return this.bytesWritten;
    }

    public void reset() {
        this.bytesWritten = 0;
        this.getChecksum().reset();
    }

    private void notifyBytesWritten(int count) {
        this.bytesWritten += count;
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }
}

