/*
 * Decompiled with CFR 0.152.
 */
package com.datomic.lucene.util;

import com.datomic.lucene.util.ArrayUtil;
import com.datomic.lucene.util.UnicodeUtil;
import java.io.UnsupportedEncodingException;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BytesRef
implements Comparable<BytesRef> {
    static final int HASH_PRIME = 31;
    public static final byte[] EMPTY_BYTES = new byte[0];
    public byte[] bytes;
    public int offset;
    public int length;
    private static final Comparator<BytesRef> utf8SortedAsUnicodeSortOrder = new UTF8SortedAsUnicodeComparator();
    private static final Comparator<BytesRef> utf8SortedAsUTF16SortOrder = new UTF8SortedAsUTF16Comparator();

    public BytesRef() {
        this.bytes = EMPTY_BYTES;
    }

    public BytesRef(byte[] bytes, int offset, int length) {
        assert (bytes != null);
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    public BytesRef(byte[] bytes) {
        assert (bytes != null);
        this.bytes = bytes;
        this.offset = 0;
        this.length = bytes.length;
    }

    public BytesRef(int capacity) {
        this.bytes = new byte[capacity];
    }

    public BytesRef(CharSequence text) {
        this();
        this.copy(text);
    }

    public BytesRef(char[] text, int offset, int length) {
        this(length * 4);
        this.copy(text, offset, length);
    }

    public BytesRef(BytesRef other) {
        this();
        this.copy(other);
    }

    public void copy(CharSequence text) {
        UnicodeUtil.UTF16toUTF8(text, 0, text.length(), this);
    }

    public void copy(char[] text, int offset, int length) {
        UnicodeUtil.UTF16toUTF8(text, offset, length, this);
    }

    public boolean bytesEquals(BytesRef other) {
        if (this.length == other.length) {
            int otherUpto = other.offset;
            byte[] otherBytes = other.bytes;
            int end = this.offset + this.length;
            int upto = this.offset;
            while (upto < end) {
                if (this.bytes[upto] != otherBytes[otherUpto]) {
                    return false;
                }
                ++upto;
                ++otherUpto;
            }
            return true;
        }
        return false;
    }

    public Object clone() {
        return new BytesRef(this);
    }

    private boolean sliceEquals(BytesRef other, int pos) {
        if (pos < 0 || this.length - pos < other.length) {
            return false;
        }
        int i = this.offset + pos;
        int j = other.offset;
        int k = other.offset + other.length;
        while (j < k) {
            if (this.bytes[i++] == other.bytes[j++]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(BytesRef other) {
        return this.sliceEquals(other, 0);
    }

    public boolean endsWith(BytesRef other) {
        return this.sliceEquals(other, this.length - other.length);
    }

    public int hashCode() {
        int result = 0;
        int end = this.offset + this.length;
        for (int i = this.offset; i < end; ++i) {
            result = 31 * result + this.bytes[i];
        }
        return result;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        return this.bytesEquals((BytesRef)other);
    }

    public String utf8ToString() {
        try {
            return new String(this.bytes, this.offset, this.length, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int end = this.offset + this.length;
        for (int i = this.offset; i < end; ++i) {
            if (i > this.offset) {
                sb.append(' ');
            }
            sb.append(Integer.toHexString(this.bytes[i] & 0xFF));
        }
        sb.append(']');
        return sb.toString();
    }

    public void copy(BytesRef other) {
        if (this.bytes.length < other.length) {
            this.bytes = new byte[other.length];
        }
        System.arraycopy(other.bytes, other.offset, this.bytes, 0, other.length);
        this.length = other.length;
        this.offset = 0;
    }

    public void append(BytesRef other) {
        int newLen = this.length + other.length;
        if (this.bytes.length < newLen) {
            byte[] newBytes = new byte[newLen];
            System.arraycopy(this.bytes, this.offset, newBytes, 0, this.length);
            this.offset = 0;
            this.bytes = newBytes;
        }
        System.arraycopy(other.bytes, other.offset, this.bytes, this.length + this.offset, other.length);
        this.length = newLen;
    }

    public void grow(int newLength) {
        this.bytes = ArrayUtil.grow(this.bytes, newLength);
    }

    @Override
    public int compareTo(BytesRef other) {
        if (this == other) {
            return 0;
        }
        byte[] aBytes = this.bytes;
        int aUpto = this.offset;
        byte[] bBytes = other.bytes;
        int bUpto = other.offset;
        int aStop = aUpto + Math.min(this.length, other.length);
        while (aUpto < aStop) {
            int bByte;
            int aByte;
            int diff;
            if ((diff = (aByte = aBytes[aUpto++] & 0xFF) - (bByte = bBytes[bUpto++] & 0xFF)) == 0) continue;
            return diff;
        }
        return this.length - other.length;
    }

    public static Comparator<BytesRef> getUTF8SortedAsUnicodeComparator() {
        return utf8SortedAsUnicodeSortOrder;
    }

    public static Comparator<BytesRef> getUTF8SortedAsUTF16Comparator() {
        return utf8SortedAsUTF16SortOrder;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UTF8SortedAsUTF16Comparator
    implements Comparator<BytesRef> {
        private UTF8SortedAsUTF16Comparator() {
        }

        @Override
        public int compare(BytesRef a, BytesRef b) {
            byte[] aBytes = a.bytes;
            int aUpto = a.offset;
            byte[] bBytes = b.bytes;
            int bUpto = b.offset;
            int aStop = a.length < b.length ? aUpto + a.length : aUpto + b.length;
            while (aUpto < aStop) {
                int bByte;
                int aByte;
                if ((aByte = aBytes[aUpto++] & 0xFF) == (bByte = bBytes[bUpto++] & 0xFF)) continue;
                if (aByte >= 238 && bByte >= 238) {
                    if ((aByte & 0xFE) == 238) {
                        aByte += 14;
                    }
                    if ((bByte & 0xFE) == 238) {
                        bByte += 14;
                    }
                }
                return aByte - bByte;
            }
            return a.length - b.length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UTF8SortedAsUnicodeComparator
    implements Comparator<BytesRef> {
        private UTF8SortedAsUnicodeComparator() {
        }

        @Override
        public int compare(BytesRef a, BytesRef b) {
            byte[] aBytes = a.bytes;
            int aUpto = a.offset;
            byte[] bBytes = b.bytes;
            int bUpto = b.offset;
            int aStop = a.length < b.length ? aUpto + a.length : aUpto + b.length;
            while (aUpto < aStop) {
                int bByte;
                int aByte;
                int diff;
                if ((diff = (aByte = aBytes[aUpto++] & 0xFF) - (bByte = bBytes[bUpto++] & 0xFF)) == 0) continue;
                return diff;
            }
            return a.length - b.length;
        }
    }
}

