/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.localfile;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.type.Type;
import java.util.Objects;

public class LocalFileColumnHandle
implements ColumnHandle {
    public static final int SERVER_ADDRESS_ORDINAL_POSITION = -1;
    public static final String SERVER_ADDRESS_COLUMN_NAME = "server_address";
    private final String columnName;
    private final Type columnType;
    private final int ordinalPosition;

    @JsonCreator
    public LocalFileColumnHandle(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="columnType") Type columnType, @JsonProperty(value="ordinalPosition") int ordinalPosition) {
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.columnType = Objects.requireNonNull(columnType, "columnType is null");
        this.ordinalPosition = ordinalPosition;
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty
    public Type getColumnType() {
        return this.columnType;
    }

    @JsonProperty
    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public ColumnMetadata toColumnMetadata() {
        return new ColumnMetadata(this.columnName, this.columnType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalFileColumnHandle that = (LocalFileColumnHandle)o;
        return Objects.equals(this.columnName, that.columnName) && Objects.equals(this.columnType, that.columnType) && Objects.equals(this.ordinalPosition, that.ordinalPosition);
    }

    public int hashCode() {
        return Objects.hash(this.columnName, this.columnType, this.ordinalPosition);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columnName", (Object)this.columnName).add("columnType", (Object)this.columnType).add("ordinalPosition", this.ordinalPosition).toString();
    }
}

