/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.localfile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.plugin.localfile.LocalFileColumnHandle;
import io.prestosql.plugin.localfile.LocalFileTableHandle;
import io.prestosql.plugin.localfile.LocalFileTables;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTableProperties;
import io.prestosql.spi.connector.Constraint;
import io.prestosql.spi.connector.ConstraintApplicationResult;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SchemaTablePrefix;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class LocalFileMetadata
implements ConnectorMetadata {
    public static final String PRESTO_LOGS_SCHEMA = "logs";
    public static final ColumnMetadata SERVER_ADDRESS_COLUMN = new ColumnMetadata("server_address", (Type)VarcharType.createUnboundedVarcharType());
    private static final List<String> SCHEMA_NAMES = ImmutableList.of((Object)"logs");
    private final LocalFileTables localFileTables;

    @Inject
    public LocalFileMetadata(LocalFileTables localFileTables) {
        this.localFileTables = Objects.requireNonNull(localFileTables, "localFileTables is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return SCHEMA_NAMES;
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        return this.localFileTables.getTable(tableName);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        LocalFileTableHandle tableHandle = (LocalFileTableHandle)table;
        return new ConnectorTableMetadata(tableHandle.getSchemaTableName(), this.localFileTables.getColumns(tableHandle));
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        return this.localFileTables.getTables();
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle table) {
        LocalFileTableHandle tableHandle = (LocalFileTableHandle)table;
        return this.getColumnHandles(tableHandle);
    }

    private Map<String, ColumnHandle> getColumnHandles(LocalFileTableHandle tableHandle) {
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        int index = 0;
        for (ColumnMetadata column : this.localFileTables.getColumns(tableHandle)) {
            int ordinalPosition = column.getName().equals("server_address") ? -1 : index++;
            columnHandles.put((Object)column.getName(), (Object)new LocalFileColumnHandle(column.getName(), column.getType(), ordinalPosition));
        }
        return columnHandles.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((LocalFileColumnHandle)columnHandle).toColumnMetadata();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix)) {
            LocalFileTableHandle tableHandle = this.localFileTables.getTable(tableName);
            if (tableHandle == null) continue;
            columns.put((Object)tableName, this.localFileTables.getColumns(tableHandle));
        }
        return columns.build();
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getTable().isEmpty()) {
            return this.listTables(session, prefix.getSchema());
        }
        return ImmutableList.of((Object)prefix.toSchemaTableName());
    }

    public boolean usesLegacyTableLayouts() {
        return false;
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return new ConnectorTableProperties();
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle table, Constraint constraint) {
        TupleDomain newDomain;
        LocalFileTableHandle handle = (LocalFileTableHandle)table;
        TupleDomain<ColumnHandle> oldDomain = handle.getConstraint();
        if (oldDomain.equals((Object)(newDomain = oldDomain.intersect(constraint.getSummary())))) {
            return Optional.empty();
        }
        handle = new LocalFileTableHandle(handle.getSchemaTableName(), handle.getTimestampColumn(), handle.getServerAddressColumn(), (TupleDomain<ColumnHandle>)newDomain);
        return Optional.of(new ConstraintApplicationResult((Object)handle, constraint.getSummary()));
    }
}

