/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.localfile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.prestosql.plugin.localfile.LocalFileColumnHandle;
import io.prestosql.plugin.localfile.LocalFileRecordCursor;
import io.prestosql.plugin.localfile.LocalFileSplit;
import io.prestosql.plugin.localfile.LocalFileTableHandle;
import io.prestosql.plugin.localfile.LocalFileTables;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.connector.RecordCursor;
import io.prestosql.spi.connector.RecordSet;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.Type;
import java.util.List;
import java.util.Objects;

public class LocalFileRecordSet
implements RecordSet {
    private final List<LocalFileColumnHandle> columns;
    private final List<Type> columnTypes;
    private final HostAddress address;
    private final TupleDomain<LocalFileColumnHandle> effectivePredicate;
    private final SchemaTableName tableName;
    private final LocalFileTables localFileTables;

    public LocalFileRecordSet(LocalFileTables localFileTables, LocalFileSplit split, LocalFileTableHandle table, List<LocalFileColumnHandle> columns) {
        this.columns = Objects.requireNonNull(columns, "column handles is null");
        Objects.requireNonNull(split, "split is null");
        ImmutableList.Builder types = ImmutableList.builder();
        for (LocalFileColumnHandle column : columns) {
            types.add((Object)column.getColumnType());
        }
        this.columnTypes = types.build();
        this.address = (HostAddress)Iterables.getOnlyElement(split.getAddresses());
        this.effectivePredicate = table.getConstraint().transform(LocalFileColumnHandle.class::cast);
        this.tableName = table.getSchemaTableName();
        this.localFileTables = Objects.requireNonNull(localFileTables, "localFileTables is null");
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new LocalFileRecordCursor(this.localFileTables, this.columns, this.tableName, this.address, this.effectivePredicate);
    }
}

