/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.localfile;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.predicate.TupleDomain;
import java.util.Objects;
import java.util.OptionalInt;

public class LocalFileTableHandle
implements ConnectorTableHandle {
    private final SchemaTableName schemaTableName;
    private final OptionalInt timestampColumn;
    private final OptionalInt serverAddressColumn;
    private final TupleDomain<ColumnHandle> constraint;

    public LocalFileTableHandle(SchemaTableName schemaTableName, OptionalInt timestampColumn, OptionalInt serverAddressColumn) {
        this(schemaTableName, timestampColumn, serverAddressColumn, (TupleDomain<ColumnHandle>)TupleDomain.all());
    }

    @JsonCreator
    public LocalFileTableHandle(@JsonProperty(value="schemaTableName") SchemaTableName schemaTableName, @JsonProperty(value="timestampColumn") OptionalInt timestampColumn, @JsonProperty(value="serverAddressColumn") OptionalInt serverAddressColumn, @JsonProperty(value="constraint") TupleDomain<ColumnHandle> constraint) {
        this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        this.timestampColumn = Objects.requireNonNull(timestampColumn, "timestampColumn is null");
        this.serverAddressColumn = Objects.requireNonNull(serverAddressColumn, "serverAddressColumn is null");
        this.constraint = Objects.requireNonNull(constraint, "constraint is null");
    }

    @JsonProperty
    public SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    @JsonProperty
    public OptionalInt getTimestampColumn() {
        return this.timestampColumn;
    }

    @JsonProperty
    public OptionalInt getServerAddressColumn() {
        return this.serverAddressColumn;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getConstraint() {
        return this.constraint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalFileTableHandle that = (LocalFileTableHandle)o;
        return Objects.equals(this.schemaTableName, that.schemaTableName) && Objects.equals(this.timestampColumn, that.timestampColumn) && Objects.equals(this.serverAddressColumn, that.serverAddressColumn) && Objects.equals(this.constraint, that.constraint);
    }

    public int hashCode() {
        return Objects.hash(this.schemaTableName, this.timestampColumn, this.serverAddressColumn, this.constraint);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("schemaTableName", (Object)this.schemaTableName).toString();
    }
}

