/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.annotations.Beta;
import io.airlift.http.client.HttpStatus;
import io.airlift.stats.CounterStat;
import io.airlift.stats.DistributionStat;
import io.airlift.stats.TimeStat;
import io.airlift.units.Duration;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@Beta
public class RequestStats {
    private final CounterStat allResponse = new CounterStat();
    private final CounterStat informationalResponse = new CounterStat();
    private final CounterStat successfulResponse = new CounterStat();
    private final CounterStat redirectionResponse = new CounterStat();
    private final CounterStat clientErrorResponse = new CounterStat();
    private final CounterStat serverErrorResponse = new CounterStat();
    private final CounterStat requestFailed = new CounterStat();
    private final CounterStat requestCanceled = new CounterStat();
    private final TimeStat requestTime = new TimeStat();
    private final TimeStat responseTime = new TimeStat();
    private final DistributionStat readBytes = new DistributionStat();
    private final DistributionStat writtenBytes = new DistributionStat();

    @Inject
    public RequestStats() {
    }

    public void recordResponseReceived(String method, int responseCode, long requestSizeInBytes, long responseSizeInBytes, Duration requestProcessingTime, Duration responseProcessingTime) {
        this.requestTime.add(requestProcessingTime);
        this.responseTime.add(responseProcessingTime);
        this.readBytes.add(responseSizeInBytes);
        this.writtenBytes.add(requestSizeInBytes);
        this.allResponse.update(1L);
        switch (HttpStatus.familyForStatusCode(responseCode)) {
            case INFORMATIONAL: {
                this.informationalResponse.update(1L);
                break;
            }
            case SUCCESSFUL: {
                this.successfulResponse.update(1L);
                break;
            }
            case REDIRECTION: {
                this.redirectionResponse.update(1L);
                break;
            }
            case CLIENT_ERROR: {
                this.clientErrorResponse.update(1L);
                break;
            }
            case SERVER_ERROR: {
                this.serverErrorResponse.update(1L);
            }
        }
    }

    public void recordRequestFailed() {
        this.requestFailed.update(1L);
    }

    public void recordRequestCanceled() {
        this.requestCanceled.update(1L);
    }

    @Managed
    @Nested
    public CounterStat getAllResponse() {
        return this.allResponse;
    }

    @Managed
    @Nested
    public CounterStat get1xxResponse() {
        return this.informationalResponse;
    }

    @Managed
    @Nested
    public CounterStat get2xxResponse() {
        return this.successfulResponse;
    }

    @Managed
    @Nested
    public CounterStat get3xxResponse() {
        return this.redirectionResponse;
    }

    @Managed
    @Nested
    public CounterStat get4xxResponse() {
        return this.clientErrorResponse;
    }

    @Managed
    @Nested
    public CounterStat get5xxResponse() {
        return this.serverErrorResponse;
    }

    @Managed
    @Nested
    public CounterStat getRequestFailed() {
        return this.requestFailed;
    }

    @Managed
    @Nested
    public CounterStat getRequestCanceled() {
        return this.requestCanceled;
    }

    @Managed
    @Nested
    public TimeStat getRequestTime() {
        return this.requestTime;
    }

    @Managed
    @Nested
    public TimeStat getResponseTime() {
        return this.responseTime;
    }

    @Managed
    @Nested
    public DistributionStat getReadBytes() {
        return this.readBytes;
    }

    @Managed
    @Nested
    public DistributionStat getWrittenBytes() {
        return this.writtenBytes;
    }
}

