/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.jetty;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;

public interface HttpClientLogger {
    public void log(RequestInfo var1, ResponseInfo var2);

    public void close();

    public int getQueueSize();

    public static class ResponseInfo {
        private final Optional<Response> response;
        private final Optional<Throwable> failureCause;
        private final long responseSize;
        private final long responseTimestampMillis = System.currentTimeMillis();
        private final long responseBeginTimestamp;
        private final long responseCompleteTimestamp;

        private ResponseInfo(Optional<Response> response, long responseSize, long responseBeginTimestamp, long responseCompleteTimestamp, Optional<Throwable> failure) {
            Objects.requireNonNull(response, "response is null");
            Objects.requireNonNull(failure, "failure is null");
            this.response = response;
            this.responseSize = responseSize;
            this.responseBeginTimestamp = responseBeginTimestamp;
            this.responseCompleteTimestamp = responseCompleteTimestamp;
            this.failureCause = failure;
        }

        public static ResponseInfo from(Optional<Response> response, long responseSize, long responseBeginTimestamp, long responseCompleteTimestamp) {
            Objects.requireNonNull(response, "response is null");
            Preconditions.checkArgument((responseSize >= 0L ? 1 : 0) != 0, (Object)"responseSize is negative");
            return new ResponseInfo(response, responseSize, responseBeginTimestamp, responseCompleteTimestamp, Optional.empty());
        }

        public static ResponseInfo failed(Optional<Response> response, Optional<Throwable> failureCause) {
            Objects.requireNonNull(response, "response is null");
            Objects.requireNonNull(failureCause, "failureCause is null");
            return new ResponseInfo(response, 0L, 0L, System.nanoTime(), failureCause);
        }

        public static ResponseInfo failed(Optional<Response> response, Optional<Throwable> failureCause, long responseBeginTimestamp, long responseCompleteTimestamp) {
            Objects.requireNonNull(response, "response is null");
            Objects.requireNonNull(failureCause, "failureCause is null");
            return new ResponseInfo(response, 0L, responseBeginTimestamp, responseCompleteTimestamp, failureCause);
        }

        public Optional<Response> getResponse() {
            return this.response;
        }

        public long getResponseSize() {
            return this.responseSize;
        }

        public Optional<Throwable> getFailureCause() {
            return this.failureCause;
        }

        public long getResponseTimestampMillis() {
            return this.responseTimestampMillis;
        }

        public long getResponseBeginTimestamp() {
            return this.responseBeginTimestamp;
        }

        public long getResponseCompleteTimestamp() {
            return this.responseCompleteTimestamp;
        }
    }

    public static class RequestInfo {
        private final Request request;
        private final long requestTimestampMillis;
        private final long requestCreatedTimestamp;
        private final long requestBeginTimestamp;
        private final long requestEndTimestamp;

        private RequestInfo(Request request, long requestTimestampMillis, long requestCreatedTimestamp, long requestBeginTimestamp, long requestEndTimestamp) {
            this.request = Objects.requireNonNull(request, "request is null");
            this.requestTimestampMillis = requestTimestampMillis;
            this.requestCreatedTimestamp = requestCreatedTimestamp;
            this.requestBeginTimestamp = requestBeginTimestamp;
            this.requestEndTimestamp = requestEndTimestamp;
        }

        public static RequestInfo from(Request request, long requestTimestampMillis) {
            Objects.requireNonNull(request, "request is null");
            return new RequestInfo(request, requestTimestampMillis, 0L, 0L, 0L);
        }

        public static RequestInfo from(Request request, long requestTimestampMillis, long requestCreatedTimestamp, long requestBeginTimestamp, long requestEndTimestamp) {
            Objects.requireNonNull(request, "request is null");
            return new RequestInfo(request, requestTimestampMillis, requestCreatedTimestamp, requestBeginTimestamp, requestEndTimestamp);
        }

        public Request getRequest() {
            return this.request;
        }

        public long getRequestTimestampMillis() {
            return this.requestTimestampMillis;
        }

        public long getRequestBeginTimestamp() {
            return this.requestBeginTimestamp;
        }

        public long getRequestEndTimestamp() {
            return this.requestEndTimestamp;
        }

        public long getRequestCreatedTimestamp() {
            return this.requestCreatedTimestamp;
        }
    }
}

