/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.InventoryItem;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class InventoryItemMarshaller {
    private static final MarshallingInfo<String> TYPENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TypeName").build();
    private static final MarshallingInfo<String> SCHEMAVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SchemaVersion").build();
    private static final MarshallingInfo<String> CAPTURETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CaptureTime").build();
    private static final MarshallingInfo<String> CONTENTHASH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContentHash").build();
    private static final MarshallingInfo<List> CONTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Content").build();
    private static final MarshallingInfo<Map> CONTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Context").build();
    private static final InventoryItemMarshaller instance = new InventoryItemMarshaller();

    public static InventoryItemMarshaller getInstance() {
        return instance;
    }

    public void marshall(InventoryItem inventoryItem, ProtocolMarshaller protocolMarshaller) {
        if (inventoryItem == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)inventoryItem.getTypeName(), TYPENAME_BINDING);
            protocolMarshaller.marshall((Object)inventoryItem.getSchemaVersion(), SCHEMAVERSION_BINDING);
            protocolMarshaller.marshall((Object)inventoryItem.getCaptureTime(), CAPTURETIME_BINDING);
            protocolMarshaller.marshall((Object)inventoryItem.getContentHash(), CONTENTHASH_BINDING);
            protocolMarshaller.marshall(inventoryItem.getContent(), CONTENT_BINDING);
            protocolMarshaller.marshall(inventoryItem.getContext(), CONTEXT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

