;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.s3-creds.cache
  (:refer-clojure :exclude (get))
  (:require
   [clojure.core.cache :as cache]
   [cognitect.s3-creds.common :refer :all]))

(defprotocol Cache
  (get [_ name] "Value in cache, or nil.")
  (put [_ name v] "Put value in cache, return nil."))

(deftype CacheImpl
  [cache-ref]
  Cache
  (get
   [this name]
   (when-let [creds (cache/lookup @cache-ref name)]
     (swap! cache-ref cache/hit name)
     creds))
  (put
   [_ name v]
   (swap! cache-ref cache/miss name v)
   nil))

(defn create
  ([] (create (cache/lru-cache-factory {} :threshold 256)))
  ([c-c-cache]
     (->CacheImpl (atom c-c-cache))))



