/*
 * Decompiled with CFR 0.152.
 */
package org.fressian.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer buf;

    public ByteBufferInputStream(ByteBuffer buf) {
        this.buf = buf.duplicate();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.buf.reset();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.buf.mark();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        byte result = this.buf.get();
        return result & 0xFF;
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int bytesRead = Math.min(len, this.buf.remaining());
        if (bytesRead <= 0) {
            return -1;
        }
        this.buf.get(bytes, off, bytesRead);
        return bytesRead;
    }

    @Override
    public long skip(long l) throws IOException {
        int skipped = Math.min((int)l, this.buf.remaining());
        if (skipped <= 0) {
            return 0L;
        }
        this.buf.position(this.buf.position() + skipped);
        return skipped;
    }

    @Override
    public int available() throws IOException {
        return this.buf.remaining();
    }
}

