/*
 * Decompiled with CFR 0.152.
 */
package org.fressian.impl;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.fressian.Reader;
import org.fressian.TaggedObject;
import org.fressian.Writer;
import org.fressian.handlers.ILookup;
import org.fressian.handlers.ReadHandler;
import org.fressian.handlers.WriteHandler;
import org.fressian.impl.CachingLookup;
import org.fressian.impl.ChainedLookup;
import org.fressian.impl.Fns;
import org.fressian.impl.InheritanceLookup;
import org.fressian.impl.MapLookup;

public class Handlers {
    public static final Map<String, Integer> tagToCode;
    public static final Map extendedReadHandlers;
    public static final ILookup<Class, Map<String, WriteHandler>> coreWriteHandlers;
    public static final ILookup<Class, Map<String, WriteHandler>> extendedWriteHandlers;

    public static Map<Class, Map<String, WriteHandler>> installHandler(Map<Class, Map<String, WriteHandler>> map, Class cls, String tag, WriteHandler handler) {
        map.put(cls, Fns.soloMap(tag, handler));
        return map;
    }

    public static ILookup<Class, Map<String, WriteHandler>> defaultWriteHandlers() {
        return new CachingLookup<Class, Map<String, WriteHandler>>(new ChainedLookup(coreWriteHandlers, extendedWriteHandlers));
    }

    public static ILookup<Class, Map<String, WriteHandler>> customWriteHandlers(ILookup<Class, Map<String, WriteHandler>> userHandlers) {
        if (userHandlers != null) {
            return new CachingLookup<Class, Map<String, WriteHandler>>(new ChainedLookup(coreWriteHandlers, userHandlers, extendedWriteHandlers));
        }
        return Handlers.defaultWriteHandlers();
    }

    static {
        HashMap<Class<Object>, Map<String, WriteHandler>> handlers = new HashMap<Class, Map<String, WriteHandler>>();
        WriteHandler intHandler = new WriteHandler(){

            @Override
            public void write(Writer w, Object instance) throws IOException {
                w.writeInt(instance);
            }
        };
        Handlers.installHandler(handlers, Short.class, "int", intHandler);
        Handlers.installHandler(handlers, Integer.class, "int", intHandler);
        Handlers.installHandler(handlers, Long.class, "int", intHandler);
        Handlers.installHandler(handlers, Boolean.class, "bool", new WriteHandler(){

            @Override
            public void write(Writer w, Object instance) throws IOException {
                w.writeBoolean(instance);
            }
        });
        Handlers.installHandler(handlers, new byte[0].getClass(), "bytes", new WriteHandler(){

            @Override
            public void write(Writer w, Object instance) throws IOException {
                byte[] bytes = (byte[])instance;
                w.writeBytes(bytes);
            }
        });
        Handlers.installHandler(handlers, Double.class, "double", new WriteHandler(){

            @Override
            public void write(Writer w, Object instance) throws IOException {
                w.writeDouble(instance);
            }
        });
        Handlers.installHandler(handlers, Float.class, "float", new WriteHandler(){

            @Override
            public void write(Writer w, Object instance) throws IOException {
                w.writeFloat(instance);
            }
        });
        Handlers.installHandler(handlers, CharSequence.class, "string", new WriteHandler(){

            @Override
            public void write(Writer w, Object instance) throws IOException {
                w.writeString(instance);
            }
        });
        Handlers.installHandler(handlers, null, "null", new WriteHandler(){

            @Override
            public void write(Writer w, Object instance) throws IOException {
                w.writeNull();
            }
        });
        Handlers.installHandler(handlers, new int[0].getClass(), "int[]", new WriteHandler(){

            @Override
            public void write(Writer w, Object instance) throws IOException {
                int[] ints = (int[])instance;
                w.writeTag("int[]", 2);
                w.writeInt(ints.length);
                for (int n = 0; n < ints.length; ++n) {
                    w.writeInt(ints[n]);
                }
            }
        });
        Handlers.installHandler(handlers, new long[0].getClass(), "long[]", new WriteHandler(){

            @Override
            public void write(Writer w, Object instance) throws IOException {
                long[] longs = (long[])instance;
                w.writeTag("long[]", 2);
                w.writeInt(longs.length);
                for (int n = 0; n < longs.length; ++n) {
                    w.writeInt(longs[n]);
                }
            }
        });
        Handlers.installHandler(handlers, new float[0].getClass(), "float[]", new WriteHandler(){

            @Override
            public void write(Writer w, Object instance) throws IOException {
                float[] floats = (float[])instance;
                w.writeTag("float[]", 2);
                w.writeInt(floats.length);
                for (int n = 0; n < floats.length; ++n) {
                    w.writeFloat(floats[n]);
                }
            }
        });
        Handlers.installHandler(handlers, new boolean[0].getClass(), "boolean[]", new WriteHandler(){

            @Override
            public void write(Writer w, Object instance) throws IOException {
                boolean[] booleans = (boolean[])instance;
                w.writeTag("boolean[]", 2);
                w.writeInt(booleans.length);
                for (int n = 0; n < booleans.length; ++n) {
                    w.writeBoolean(booleans[n]);
                }
            }
        });
        Handlers.installHandler(handlers, new double[0].getClass(), "double[]", new WriteHandler(){

            @Override
            public void write(Writer w, Object instance) throws IOException {
                double[] doubles = (double[])instance;
                w.writeTag("double[]", 2);
                w.writeInt(doubles.length);
                for (int n = 0; n < doubles.length; ++n) {
                    w.writeDouble(doubles[n]);
                }
            }
        });
        Handlers.installHandler(handlers, new Object[0].getClass(), "Object[]", new WriteHandler(){

            @Override
            public void write(Writer w, Object instance) throws IOException {
                Object[] objects = (Object[])instance;
                w.writeTag("Object[]", 2);
                w.writeInt(objects.length);
                for (int n = 0; n < objects.length; ++n) {
                    w.writeObject(objects[n]);
                }
            }
        });
        Handlers.installHandler(handlers, TaggedObject.class, "any", new WriteHandler(){

            @Override
            public void write(Writer w, Object instance) throws IOException {
                TaggedObject t = (TaggedObject)instance;
                Object[] value = t.getValue();
                w.writeTag(t.getTag(), value.length);
                for (int n = 0; n < value.length; ++n) {
                    w.writeObject(value[n]);
                }
            }
        });
        coreWriteHandlers = new InheritanceLookup<Map<String, WriteHandler>>(new MapLookup<Class, Map<String, WriteHandler>>(handlers));
        HashMap<String, Integer> builder = new HashMap<String, Integer>();
        builder.put("map", 192);
        builder.put("set", 193);
        builder.put("uuid", 195);
        builder.put("regex", 196);
        builder.put("uri", 197);
        builder.put("bigint", 198);
        builder.put("bigdec", 199);
        builder.put("inst", 200);
        builder.put("sym", 201);
        builder.put("key", 202);
        builder.put("int[]", 179);
        builder.put("float[]", 180);
        builder.put("double[]", 177);
        builder.put("long[]", 176);
        builder.put("boolean[]", 178);
        builder.put("Object[]", 181);
        tagToCode = Collections.unmodifiableMap(builder);
        handlers = new HashMap();
        handlers.put((Class)((Object)"set"), (Map<String, WriteHandler>)((Object)new ReadHandler(){

            @Override
            public Object read(Reader r, Object tag, int componentCount) throws IOException {
                HashSet s = new HashSet();
                s.addAll((List)r.readObject());
                return s;
            }
        }));
        handlers.put((Class<Object>)((Object)"map"), (Map<String, WriteHandler>)((Object)new ReadHandler(){

            @Override
            public Object read(Reader r, Object tag, int componentCount) throws IOException {
                HashMap result = new HashMap();
                List kvs = (List)((Object)((RandomAccess)r.readObject()));
                for (int i = 0; i < kvs.size(); i += 2) {
                    result.put(kvs.get(i), kvs.get(i + 1));
                }
                return result;
            }
        }));
        handlers.put((Class<Object>)((Object)"int[]"), (Map<String, WriteHandler>)((Object)new ReadHandler(){

            @Override
            public Object read(Reader r, Object tag, int componentCount) throws IOException {
                int size = Fns.intCast(r.readInt());
                int[] result = new int[size];
                for (int n = 0; n < size; ++n) {
                    result[n] = Fns.intCast(r.readInt());
                }
                return result;
            }
        }));
        handlers.put((Class<Object>)((Object)"long[]"), (Map<String, WriteHandler>)((Object)new ReadHandler(){

            @Override
            public Object read(Reader r, Object tag, int componentCount) throws IOException {
                int size = Fns.intCast(r.readInt());
                long[] result = new long[size];
                for (int n = 0; n < size; ++n) {
                    result[n] = r.readInt();
                }
                return result;
            }
        }));
        handlers.put((Class<Object>)((Object)"float[]"), (Map<String, WriteHandler>)((Object)new ReadHandler(){

            @Override
            public Object read(Reader r, Object tag, int componentCount) throws IOException {
                int size = Fns.intCast(r.readInt());
                float[] result = new float[size];
                for (int n = 0; n < size; ++n) {
                    result[n] = r.readFloat();
                }
                return result;
            }
        }));
        handlers.put((Class<Object>)((Object)"boolean[]"), (Map<String, WriteHandler>)((Object)new ReadHandler(){

            @Override
            public Object read(Reader r, Object tag, int componentCount) throws IOException {
                int size = Fns.intCast(r.readInt());
                boolean[] result = new boolean[size];
                for (int n = 0; n < size; ++n) {
                    result[n] = r.readBoolean();
                }
                return result;
            }
        }));
        handlers.put((Class<Object>)((Object)"double[]"), (Map<String, WriteHandler>)((Object)new ReadHandler(){

            @Override
            public Object read(Reader r, Object tag, int componentCount) throws IOException {
                int size = Fns.intCast(r.readInt());
                double[] result = new double[size];
                for (int n = 0; n < size; ++n) {
                    result[n] = r.readDouble();
                }
                return result;
            }
        }));
        handlers.put((Class<Object>)((Object)"Object[]"), (Map<String, WriteHandler>)((Object)new ReadHandler(){

            @Override
            public Object read(Reader r, Object tag, int componentCount) throws IOException {
                int size = Fns.intCast(r.readInt());
                Object[] result = new Object[size];
                for (int n = 0; n < size; ++n) {
                    result[n] = r.readObject();
                }
                return result;
            }
        }));
        handlers.put((Class<Object>)((Object)"uuid"), (Map<String, WriteHandler>)((Object)new ReadHandler(){

            @Override
            public Object read(Reader r, Object tag, int componentCount) throws IOException {
                byte[] buf = (byte[])r.readObject();
                if (buf.length != 16) {
                    throw new IOException("Invalid uuid buffer size: " + buf.length);
                }
                return Fns.byteArrayToUUID(buf);
            }
        }));
        handlers.put((Class<Object>)((Object)"regex"), (Map<String, WriteHandler>)((Object)new ReadHandler(){

            @Override
            public Object read(Reader r, Object tag, int componentCount) throws IOException {
                return Pattern.compile((String)r.readObject());
            }
        }));
        handlers.put((Class<Object>)((Object)"uri"), (Map<String, WriteHandler>)((Object)new ReadHandler(){

            @Override
            public Object read(Reader r, Object tag, int componentCount) throws IOException {
                try {
                    return new URI((String)r.readObject());
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
        }));
        handlers.put((Class<Object>)((Object)"bigint"), (Map<String, WriteHandler>)((Object)new ReadHandler(){

            @Override
            public Object read(Reader r, Object tag, int componentCount) throws IOException {
                return new BigInteger((byte[])r.readObject());
            }
        }));
        handlers.put((Class<Object>)((Object)"bigdec"), (Map<String, WriteHandler>)((Object)new ReadHandler(){

            @Override
            public Object read(Reader r, Object tag, int componentCount) throws IOException {
                return new BigDecimal(new BigInteger((byte[])r.readObject()), (int)r.readInt());
            }
        }));
        handlers.put((Class<Object>)((Object)"inst"), (Map<String, WriteHandler>)((Object)new ReadHandler(){

            @Override
            public Object read(Reader r, Object tag, int componentCount) throws IOException {
                return new Date(r.readInt());
            }
        }));
        extendedReadHandlers = Collections.unmodifiableMap(handlers);
        handlers = new HashMap();
        Handlers.installHandler(handlers, List.class, "list", new WriteHandler(){

            @Override
            public void write(Writer w, Object instance) throws IOException {
                w.writeList(instance);
            }
        });
        Handlers.installHandler(handlers, Date.class, "inst", new WriteHandler(){

            @Override
            public void write(Writer w, Object instance) throws IOException {
                w.writeTag("inst", 1);
                w.writeInt(((Date)instance).getTime());
            }
        });
        Handlers.installHandler(handlers, Set.class, "set", new WriteHandler(){

            @Override
            public void write(Writer w, Object instance) throws IOException {
                w.writeTag("set", 1);
                w.writeList(instance);
            }
        });
        Handlers.installHandler(handlers, Map.class, "map", new WriteHandler(){

            @Override
            public void write(Writer w, Object instance) throws IOException {
                w.writeTag("map", 1);
                Map m = (Map)instance;
                ArrayList<Object> l = new ArrayList<Object>();
                for (Map.Entry e : m.entrySet()) {
                    l.add(e.getKey());
                    l.add(e.getValue());
                }
                w.writeList(l);
            }
        });
        Handlers.installHandler(handlers, BigInteger.class, "bigint", new WriteHandler(){

            @Override
            public void write(Writer w, Object instance) throws IOException {
                BigInteger b = (BigInteger)instance;
                w.writeTag("bigint", 1);
                w.writeBytes(b.toByteArray());
            }
        });
        Handlers.installHandler(handlers, BigDecimal.class, "bigdec", new WriteHandler(){

            @Override
            public void write(Writer w, Object instance) throws IOException {
                BigDecimal d = (BigDecimal)instance;
                w.writeTag("bigdec", 2);
                w.writeBytes(d.unscaledValue().toByteArray());
                w.writeInt(d.scale());
            }
        });
        Handlers.installHandler(handlers, Pattern.class, "regex", new WriteHandler(){

            @Override
            public void write(Writer w, Object instance) throws IOException {
                Pattern re = (Pattern)instance;
                w.writeTag("regex", 1);
                w.writeString(re.pattern());
            }
        });
        Handlers.installHandler(handlers, URI.class, "uri", new WriteHandler(){

            @Override
            public void write(Writer w, Object instance) throws IOException {
                URI uri = (URI)instance;
                w.writeTag("uri", 1);
                w.writeString(uri.toString());
            }
        });
        Handlers.installHandler(handlers, UUID.class, "uuid", new WriteHandler(){

            @Override
            public void write(Writer w, Object instance) throws IOException {
                UUID uuid = (UUID)instance;
                w.writeTag("uuid", 1);
                w.writeBytes(Fns.UUIDtoByteArray(uuid));
            }
        });
        extendedWriteHandlers = new InheritanceLookup<Map<String, WriteHandler>>(new MapLookup<Class, Map<String, WriteHandler>>(Collections.unmodifiableMap(handlers)));
    }
}

