/*
 * Decompiled with CFR 0.152.
 */
package org.fressian.impl;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;

public class RawInput
implements Closeable {
    private final InputStream is;
    private final CheckedInputStream cis;
    private final DataInputStream dis;
    private int bytesRead;

    public RawInput(InputStream is) {
        this(is, true);
    }

    public RawInput(InputStream is, boolean validateAdler) {
        if (validateAdler) {
            this.cis = new CheckedInputStream(is, new Adler32());
            this.is = this.cis;
        } else {
            this.is = is;
            this.cis = null;
        }
        this.dis = new DataInputStream(this.is);
    }

    public int readRawByte() throws IOException {
        int result = this.is.read();
        if (result < 0) {
            throw new EOFException();
        }
        ++this.bytesRead;
        return result;
    }

    public long readRawInt8() throws IOException {
        return this.readRawByte();
    }

    public long readRawInt16() throws IOException {
        return (this.readRawByte() << 8) + this.readRawByte();
    }

    public long readRawInt24() throws IOException {
        return (this.readRawByte() << 16) + (this.readRawByte() << 8) + this.readRawByte();
    }

    public long readRawInt32() throws IOException {
        this.bytesRead += 4;
        return (long)this.dis.readInt() & 0xFFFFFFFFL;
    }

    public long readRawInt40() throws IOException {
        return this.readRawInt8() << 32 | this.readRawInt32();
    }

    public long readRawInt48() throws IOException {
        return this.readRawInt16() << 32 | this.readRawInt32();
    }

    public long readRawInt64() throws IOException {
        this.bytesRead += 8;
        return this.dis.readLong();
    }

    public float readRawFloat() throws IOException {
        this.bytesRead += 4;
        return this.dis.readFloat();
    }

    public double readRawDouble() throws IOException {
        this.bytesRead += 8;
        return this.dis.readDouble();
    }

    public void readFully(byte[] bytes, int offset, int length) throws IOException {
        this.dis.readFully(bytes, offset, length);
        this.bytesRead += length;
    }

    public int getBytesRead() {
        return this.bytesRead;
    }

    public void reset() {
        this.bytesRead = 0;
        if (this.cis != null) {
            this.cis.getChecksum().reset();
        }
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    public void validateChecksum() throws IOException {
        if (this.cis == null) {
            this.readRawInt32();
        } else {
            int checksumFromStream;
            int calculatedChecksum = (int)this.cis.getChecksum().getValue();
            if (calculatedChecksum != (checksumFromStream = (int)this.readRawInt32())) {
                throw new RuntimeException(String.format("Invalid footer checksum, expected %X got %X", calculatedChecksum, checksumFromStream));
            }
        }
    }
}

