/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.security;

import com.google.common.base.Preconditions;
import io.prestosql.plugin.base.security.AllowAllSystemAccessControl;
import io.prestosql.spi.security.AccessDeniedException;
import io.prestosql.spi.security.SystemAccessControl;
import io.prestosql.spi.security.SystemAccessControlFactory;
import io.prestosql.spi.security.SystemSecurityContext;
import java.util.Map;
import java.util.Objects;

public class DefaultSystemAccessControl
extends AllowAllSystemAccessControl {
    public static final String NAME = "default";
    private static final DefaultSystemAccessControl INSTANCE = new DefaultSystemAccessControl();

    @Override
    public void checkCanImpersonateUser(SystemSecurityContext context, String userName) {
        AccessDeniedException.denyImpersonateUser((String)context.getIdentity().getUser(), (String)userName);
    }

    public static class Factory
    implements SystemAccessControlFactory {
        public String getName() {
            return DefaultSystemAccessControl.NAME;
        }

        public SystemAccessControl create(Map<String, String> config) {
            Objects.requireNonNull(config, "config is null");
            Preconditions.checkArgument((boolean)config.isEmpty(), (Object)"This access controller does not support any configuration properties");
            return INSTANCE;
        }
    }
}

