/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeScheduledInstancesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.SlotStartTimeRangeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class DescribeScheduledInstancesRequestMarshaller
implements Marshaller<Request<DescribeScheduledInstancesRequest>, DescribeScheduledInstancesRequest> {
    public Request<DescribeScheduledInstancesRequest> marshall(DescribeScheduledInstancesRequest describeScheduledInstancesRequest) {
        SdkInternalList filtersList;
        SlotStartTimeRangeRequest slotStartTimeRange;
        if (describeScheduledInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeScheduledInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeScheduledInstances");
        request.addParameter("Version", "2016-04-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList scheduledInstanceIdsList = (SdkInternalList)describeScheduledInstancesRequest.getScheduledInstanceIds();
        if (!scheduledInstanceIdsList.isEmpty() || !scheduledInstanceIdsList.isAutoConstruct()) {
            int scheduledInstanceIdsListIndex = 1;
            for (String scheduledInstanceIdsListValue : scheduledInstanceIdsList) {
                if (scheduledInstanceIdsListValue != null) {
                    request.addParameter("ScheduledInstanceId." + scheduledInstanceIdsListIndex, StringUtils.fromString((String)scheduledInstanceIdsListValue));
                }
                ++scheduledInstanceIdsListIndex;
            }
        }
        if ((slotStartTimeRange = describeScheduledInstancesRequest.getSlotStartTimeRange()) != null) {
            if (slotStartTimeRange.getEarliestTime() != null) {
                request.addParameter("SlotStartTimeRange.EarliestTime", StringUtils.fromDate((Date)slotStartTimeRange.getEarliestTime()));
            }
            if (slotStartTimeRange.getLatestTime() != null) {
                request.addParameter("SlotStartTimeRange.LatestTime", StringUtils.fromDate((Date)slotStartTimeRange.getLatestTime()));
            }
        }
        if (describeScheduledInstancesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeScheduledInstancesRequest.getNextToken()));
        }
        if (describeScheduledInstancesRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeScheduledInstancesRequest.getMaxResults()));
        }
        if (!(filtersList = (SdkInternalList)describeScheduledInstancesRequest.getFilters()).isEmpty() || !filtersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                SdkInternalList valuesList;
                if (filtersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                }
                if (!(valuesList = (SdkInternalList)filtersListValue.getValues()).isEmpty() || !valuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

