/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.connector.system;

import com.google.common.collect.ImmutableList;
import io.prestosql.connector.system.SystemColumnHandle;
import io.prestosql.connector.system.SystemSplit;
import io.prestosql.connector.system.SystemTableHandle;
import io.prestosql.connector.system.SystemTablesProvider;
import io.prestosql.connector.system.SystemTransactionHandle;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorPageSourceProvider;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.EmptyPageSource;
import io.prestosql.spi.connector.RecordCursor;
import io.prestosql.spi.connector.RecordPageSource;
import io.prestosql.spi.connector.RecordSet;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SystemTable;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.Type;
import io.prestosql.split.MappedPageSource;
import io.prestosql.split.MappedRecordSet;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class SystemPageSourceProvider
implements ConnectorPageSourceProvider {
    private final SystemTablesProvider tables;

    public SystemPageSourceProvider(SystemTablesProvider tables) {
        this.tables = Objects.requireNonNull(tables, "tables is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns, TupleDomain<ColumnHandle> dynamicFilter) {
        Objects.requireNonNull(columns, "columns is null");
        SystemTransactionHandle systemTransaction = (SystemTransactionHandle)transaction;
        SystemSplit systemSplit = (SystemSplit)split;
        SchemaTableName tableName = ((SystemTableHandle)table).getSchemaTableName();
        SystemTable systemTable = this.tables.getSystemTable(session, tableName).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("Table '%s' not found", tableName)));
        List tableColumns = systemTable.getTableMetadata().getColumns();
        HashMap<String, Integer> columnsByName = new HashMap<String, Integer>();
        for (int i = 0; i < tableColumns.size(); ++i) {
            ColumnMetadata column = (ColumnMetadata)tableColumns.get(i);
            if (columnsByName.put(column.getName(), i) == null) continue;
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Duplicate column name: " + column.getName());
        }
        ImmutableList.Builder userToSystemFieldIndex = ImmutableList.builder();
        for (ColumnHandle column : columns) {
            String columnName = ((SystemColumnHandle)column).getColumnName();
            Integer index = (Integer)columnsByName.get(columnName);
            if (index == null) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Column does not exist: %s.%s", tableName, columnName));
            }
            userToSystemFieldIndex.add((Object)index);
        }
        TupleDomain<ColumnHandle> constraint = systemSplit.getConstraint();
        if (constraint.isNone()) {
            return new EmptyPageSource();
        }
        TupleDomain newConstraint = systemSplit.getConstraint().transform(columnHandle -> (Integer)columnsByName.get(((SystemColumnHandle)columnHandle).getColumnName()));
        try {
            return new MappedPageSource(systemTable.pageSource(systemTransaction.getConnectorTransactionHandle(), session, newConstraint), (List<Integer>)userToSystemFieldIndex.build());
        }
        catch (UnsupportedOperationException e) {
            return new RecordPageSource((RecordSet)new MappedRecordSet(SystemPageSourceProvider.toRecordSet(systemTransaction.getConnectorTransactionHandle(), systemTable, session, (TupleDomain<Integer>)newConstraint), (List<Integer>)userToSystemFieldIndex.build()));
        }
    }

    private static RecordSet toRecordSet(final ConnectorTransactionHandle sourceTransaction, final SystemTable table, final ConnectorSession session, final TupleDomain<Integer> constraint) {
        return new RecordSet(){
            private final List<Type> types;
            {
                this.types = (List)table.getTableMetadata().getColumns().stream().map(ColumnMetadata::getType).collect(ImmutableList.toImmutableList());
            }

            public List<Type> getColumnTypes() {
                return this.types;
            }

            public RecordCursor cursor() {
                return table.cursor(sourceTransaction, session, constraint);
            }
        };
    }
}

