/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.security.AccessControl;
import io.prestosql.security.InjectedConnectorAccessControl;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.connector.ConnectorAccessControl;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.eventlistener.RoutineInfo;
import io.prestosql.spi.procedure.Procedure;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeUtils;
import io.prestosql.sql.ParameterUtils;
import io.prestosql.sql.analyzer.SemanticExceptions;
import io.prestosql.sql.planner.ExpressionInterpreter;
import io.prestosql.sql.planner.ParameterRewriter;
import io.prestosql.sql.tree.Call;
import io.prestosql.sql.tree.CallArgument;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.ExpressionRewriter;
import io.prestosql.sql.tree.ExpressionTreeRewriter;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.Parameter;
import io.prestosql.sql.tree.Statement;
import io.prestosql.transaction.TransactionManager;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class CallTask
implements DataDefinitionTask<Call> {
    @Override
    public String getName() {
        return "CALL";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ListenableFuture<?> execute(Call call, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        void var19_27;
        if (!transactionManager.isAutoCommit(stateMachine.getSession().getRequiredTransactionId())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Procedures cannot be called within a transaction (use autocommit mode)");
        }
        Session session = stateMachine.getSession();
        QualifiedObjectName procedureName = MetadataUtil.createQualifiedObjectName(session, (Node)call, call.getName());
        CatalogName catalogName = metadata.getCatalogHandle(stateMachine.getSession(), procedureName.getCatalogName()).orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.CATALOG_NOT_FOUND, (Node)call, "Catalog '%s' does not exist", procedureName.getCatalogName()));
        Procedure procedure = metadata.getProcedureRegistry().resolve(catalogName, procedureName.asSchemaTableName());
        HashMap<String, Integer> positions = new HashMap<String, Integer>();
        for (int i = 0; i < procedure.getArguments().size(); ++i) {
            positions.put(((Procedure.Argument)procedure.getArguments().get(i)).getName(), i);
        }
        Predicate<CallArgument> hasName = argument -> argument.getName().isPresent();
        boolean anyNamed = call.getArguments().stream().anyMatch(hasName);
        boolean allNamed = call.getArguments().stream().allMatch(hasName);
        if (anyNamed && !allNamed) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, (Node)call, "Named and positional arguments cannot be mixed", new Object[0]);
        }
        LinkedHashMap<String, CallArgument> names = new LinkedHashMap<String, CallArgument>();
        for (int i = 0; i < call.getArguments().size(); ++i) {
            CallArgument argument2 = (CallArgument)call.getArguments().get(i);
            if (argument2.getName().isPresent()) {
                String name = (String)argument2.getName().get();
                if (names.put(name, argument2) != null) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, (Node)argument2, "Duplicate procedure argument: %s", name);
                }
                if (positions.containsKey(name)) continue;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, (Node)argument2, "Unknown argument name: %s", name);
            }
            if (i < procedure.getArguments().size()) {
                names.put(((Procedure.Argument)procedure.getArguments().get(i)).getName(), argument2);
                continue;
            }
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, (Node)call, "Too many arguments for procedure", new Object[0]);
        }
        procedure.getArguments().stream().filter(Procedure.Argument::isRequired).filter(argument -> !names.containsKey(argument.getName())).map(Procedure.Argument::getName).findFirst().ifPresent(argument -> {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, (Node)call, "Required procedure argument '%s' is missing", argument);
        });
        Object[] values = new Object[procedure.getArguments().size()];
        Map<NodeRef<Parameter>, Expression> parameterLookup = ParameterUtils.parameterExtractor((Statement)call, parameters);
        for (Map.Entry entry : names.entrySet()) {
            CallArgument callArgument = (CallArgument)entry.getValue();
            int index = (Integer)positions.get(entry.getKey());
            Procedure.Argument argument3 = (Procedure.Argument)procedure.getArguments().get(index);
            Expression expression = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(parameterLookup), (Expression)callArgument.getValue());
            Type type = argument3.getType();
            Object value = ExpressionInterpreter.evaluateConstantExpression(expression, type, metadata, session, accessControl, parameterLookup);
            values[index] = CallTask.toTypeObjectValue(session, type, value);
        }
        for (int i = 0; i < procedure.getArguments().size(); ++i) {
            Procedure.Argument argument2 = (Procedure.Argument)procedure.getArguments().get(i);
            if (names.containsKey(argument2.getName())) continue;
            Verify.verify((boolean)argument2.isOptional());
            values[i] = CallTask.toTypeObjectValue(session, argument2.getType(), argument2.getDefaultValue());
        }
        MethodType methodType = procedure.getMethodHandle().type();
        boolean bl = false;
        while (var19_27 < procedure.getArguments().size()) {
            if (values[var19_27] == null && ((Class)methodType.parameterType((int)var19_27)).isPrimitive()) {
                String name = ((Procedure.Argument)procedure.getArguments().get((int)var19_27)).getName();
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "Procedure argument cannot be null: " + name);
            }
            ++var19_27;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator<Object> valuesIterator = Arrays.asList(values).iterator();
        for (Class<?> type : methodType.parameterList()) {
            if (ConnectorSession.class.equals(type)) {
                arrayList.add(session.toConnectorSession(catalogName));
                continue;
            }
            if (ConnectorAccessControl.class.equals(type)) {
                arrayList.add(new InjectedConnectorAccessControl(accessControl, session.toSecurityContext(), catalogName.getCatalogName()));
                continue;
            }
            arrayList.add(valuesIterator.next());
        }
        accessControl.checkCanExecuteProcedure(session.toSecurityContext(), procedureName);
        stateMachine.setRoutines((List<RoutineInfo>)ImmutableList.of((Object)new RoutineInfo(procedureName.getObjectName(), session.getUser())));
        try {
            procedure.getMethodHandle().invokeWithArguments(arrayList);
        }
        catch (Throwable t) {
            if (t instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            Throwables.throwIfInstanceOf((Throwable)t, PrestoException.class);
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.PROCEDURE_CALL_FAILED, t);
        }
        return Futures.immediateFuture(null);
    }

    private static Object toTypeObjectValue(Session session, Type type, Object value) {
        BlockBuilder blockBuilder = type.createBlockBuilder(null, 1);
        TypeUtils.writeNativeValue((Type)type, (BlockBuilder)blockBuilder, (Object)value);
        return type.getObjectValue(session.toConnectorSession(), (Block)blockBuilder, 0);
    }
}

