/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.Session;
import io.prestosql.cost.StatsCalculator;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.connector.ConnectorViewDefinition;
import io.prestosql.spi.security.GroupProvider;
import io.prestosql.sql.ParameterUtils;
import io.prestosql.sql.SqlFormatterUtil;
import io.prestosql.sql.analyzer.Analysis;
import io.prestosql.sql.analyzer.Analyzer;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.tree.CreateView;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.Statement;
import io.prestosql.transaction.TransactionManager;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class CreateViewTask
implements DataDefinitionTask<CreateView> {
    private final SqlParser sqlParser;
    private final GroupProvider groupProvider;
    private final StatsCalculator statsCalculator;

    @Inject
    public CreateViewTask(SqlParser sqlParser, GroupProvider groupProvider, StatsCalculator statsCalculator) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.groupProvider = Objects.requireNonNull(groupProvider, "groupProvider is null");
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
    }

    @Override
    public String getName() {
        return "CREATE VIEW";
    }

    @Override
    public String explain(CreateView statement, List<Expression> parameters) {
        return "CREATE VIEW " + statement.getName();
    }

    @Override
    public ListenableFuture<?> execute(CreateView statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        Session session = stateMachine.getSession();
        QualifiedObjectName name = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName());
        accessControl.checkCanCreateView(session.toSecurityContext(), name);
        String sql = SqlFormatterUtil.getFormattedSql((Statement)statement.getQuery(), this.sqlParser);
        Analysis analysis = new Analyzer(session, metadata, this.sqlParser, this.groupProvider, accessControl, Optional.empty(), parameters, ParameterUtils.parameterExtractor((Statement)statement, parameters), stateMachine.getWarningCollector(), this.statsCalculator).analyze((Statement)statement);
        List columns = (List)analysis.getOutputDescriptor((Node)statement.getQuery()).getVisibleFields().stream().map(field -> new ConnectorViewDefinition.ViewColumn(field.getName().get(), field.getType().getTypeId())).collect(ImmutableList.toImmutableList());
        Optional<String> owner = Optional.of(session.getUser());
        if (statement.getSecurity().orElse(null) == CreateView.Security.INVOKER) {
            owner = Optional.empty();
        }
        ConnectorViewDefinition definition = new ConnectorViewDefinition(sql, session.getCatalog(), session.getSchema(), columns, statement.getComment(), owner, owner.isEmpty());
        metadata.createView(session, name, definition, statement.isReplace());
        return Futures.immediateFuture(null);
    }
}

