/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.base.Throwables;
import io.airlift.concurrent.SetThreadName;
import io.prestosql.Session;
import io.prestosql.event.SplitMonitor;
import io.prestosql.execution.SqlTaskExecution;
import io.prestosql.execution.TaskManagerConfig;
import io.prestosql.execution.TaskSource;
import io.prestosql.execution.TaskStateMachine;
import io.prestosql.execution.buffer.OutputBuffer;
import io.prestosql.execution.executor.TaskExecutor;
import io.prestosql.memory.QueryContext;
import io.prestosql.operator.TaskContext;
import io.prestosql.sql.planner.LocalExecutionPlanner;
import io.prestosql.sql.planner.PlanFragment;
import io.prestosql.sql.planner.TypeProvider;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.concurrent.Executor;

public class SqlTaskExecutionFactory {
    private final Executor taskNotificationExecutor;
    private final TaskExecutor taskExecutor;
    private final LocalExecutionPlanner planner;
    private final SplitMonitor splitMonitor;
    private final boolean perOperatorCpuTimerEnabled;
    private final boolean cpuTimerEnabled;

    public SqlTaskExecutionFactory(Executor taskNotificationExecutor, TaskExecutor taskExecutor, LocalExecutionPlanner planner, SplitMonitor splitMonitor, TaskManagerConfig config) {
        this.taskNotificationExecutor = Objects.requireNonNull(taskNotificationExecutor, "taskNotificationExecutor is null");
        this.taskExecutor = Objects.requireNonNull(taskExecutor, "taskExecutor is null");
        this.planner = Objects.requireNonNull(planner, "planner is null");
        this.splitMonitor = Objects.requireNonNull(splitMonitor, "splitMonitor is null");
        Objects.requireNonNull(config, "config is null");
        this.perOperatorCpuTimerEnabled = config.isPerOperatorCpuTimerEnabled();
        this.cpuTimerEnabled = config.isTaskCpuTimerEnabled();
    }

    public SqlTaskExecution create(Session session, QueryContext queryContext, TaskStateMachine taskStateMachine, OutputBuffer outputBuffer, PlanFragment fragment, List<TaskSource> sources, Runnable notifyStatusChanged, OptionalInt totalPartitions) {
        LocalExecutionPlanner.LocalExecutionPlan localExecutionPlan;
        TaskContext taskContext = queryContext.addTaskContext(taskStateMachine, session, notifyStatusChanged, this.perOperatorCpuTimerEnabled, this.cpuTimerEnabled, totalPartitions);
        try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{taskStateMachine.getTaskId()});){
            try {
                localExecutionPlan = this.planner.plan(taskContext, fragment.getRoot(), TypeProvider.copyOf(fragment.getSymbols()), fragment.getPartitioningScheme(), fragment.getStageExecutionDescriptor(), fragment.getPartitionedSources(), outputBuffer);
            }
            catch (Throwable e) {
                taskStateMachine.failed(e);
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return SqlTaskExecution.createSqlTaskExecution(taskStateMachine, taskContext, outputBuffer, sources, localExecutionPlan, this.taskExecutor, this.taskNotificationExecutor, this.splitMonitor);
    }
}

