/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.memory;

import io.prestosql.execution.TaskManager;
import io.prestosql.memory.LocalMemoryManager;
import io.prestosql.memory.MemoryInfo;
import io.prestosql.memory.MemoryPoolAssignmentsRequest;
import io.prestosql.server.security.ResourceSecurity;
import io.prestosql.spi.memory.MemoryPoolInfo;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/v1/memory")
public class MemoryResource {
    private final LocalMemoryManager memoryManager;
    private final TaskManager taskManager;

    @Inject
    public MemoryResource(LocalMemoryManager memoryManager, TaskManager taskManager) {
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager is null");
        this.taskManager = Objects.requireNonNull(taskManager, "taskManager is null");
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.INTERNAL_ONLY)
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public MemoryInfo getMemoryInfo(MemoryPoolAssignmentsRequest request) {
        this.taskManager.updateMemoryPoolAssignments(request);
        return this.memoryManager.getInfo();
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.MANAGEMENT_READ)
    @GET
    @Path(value="{poolId}")
    public Response getMemoryInfo(@PathParam(value="poolId") String poolId) {
        if (LocalMemoryManager.GENERAL_POOL.getId().equals(poolId)) {
            return this.toSuccessfulResponse(this.memoryManager.getGeneralPool().getInfo());
        }
        if (LocalMemoryManager.RESERVED_POOL.getId().equals(poolId) && this.memoryManager.getReservedPool().isPresent()) {
            return this.toSuccessfulResponse(this.memoryManager.getReservedPool().get().getInfo());
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    private Response toSuccessfulResponse(MemoryPoolInfo memoryInfo) {
        return Response.ok().entity((Object)memoryInfo).build();
    }
}

